% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_model_internal.R
\name{aggregate_model_internal}
\alias{aggregate_model_internal}
\title{An Internal Function to Aggregate Model Output Using other Idmodelr functions.}
\usage{
aggregate_model_internal(df, aggregate_to = NULL, compartments = NULL,
  strat = NULL, hold_out_var = NULL, new_var = "incidence",
  id_col = NULL, groups = NULL, total_pop = TRUE,
  summary_var = FALSE)
}
\arguments{
\item{df}{A dataframe of Model Output.}

\item{aggregate_to}{A character vector specifying the aggregation function to apply possible values are;
disease, demographic, or incidence.}

\item{compartments}{A character vector specifying the unique compartments to aggregate.}

\item{strat}{The number of stratified groups in the model.}

\item{hold_out_var}{A character  vector specifying the unique compartments not to aggregate.}

\item{new_var}{A character vector specifying the new variable to add when aggregating incidence.}

\item{id_col}{A character string containing the name of the new id column.}

\item{groups}{A character vector with length equal to the level of stratification.
Used to name the stratified levels.}

\item{total_pop}{A logical (defaults to \code{TRUE}) indicating if the total population should be
calculated when summarising the model demographics.}

\item{summary_var}{A logical (defaults to \code{FALSE}), specifying whether to add an additional summary variable across
all stratified levels.}
}
\value{
An aggregated dataframe.
}
\description{
An Internal Function to Aggregate Model Output Using other Idmodelr functions.
}
\examples{

df <- data.frame(time = 1, A1 = 1, B1 = 1, A2 = 1, B2 = 1, A3 = 1, B3 = 1)

## Incidence
aggregate_model_internal(df, aggregate_to = "incidence",
                        compartments = c("A", "B"), strat = 3,
                        summary_var = TRUE)

## Demographic
aggregate_model_internal(df, aggregate_to = "demographic",
                        compartments = c("A", "B"), strat = 3,
                        summary_var = TRUE)
## Disease
aggregate_model_internal(df, aggregate_to = "disease",
                        compartments = c("A", "B"), strat = 3,
                        summary_var = TRUE)
## Tidy (long)
aggregate_model_internal(df, aggregate_to = "tidy",
                        compartments = c("A", "B"), hold_out_var = "time", strat = 3,
                        summary_var = TRUE, id_col = "Age",
                        groups = c("Children", "Young adults", "Adults"))
}
\seealso{
aggregate_model aggregate_model_internal combine_to_age_model combine_strat_model_output summarise_var_by_strat
}
