% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sat_vapor_pressure.R
\encoding{UTF-8}
\name{sat_vapor_pressure_ice}
\alias{sat_vapor_pressure_ice}
\title{Saturation Vapor Pressure for Ice}
\usage{
sat_vapor_pressure_ice(Temp, units = c("SI", "Eng", "Absolute"))
}
\arguments{
\item{Temp}{numeric vector that contains the temperature (degrees Celsius,
degrees Fahrenheit, or Kelvin)}

\item{units}{character vector that contains the system of units {options are
\code{SI} for International System of Units, \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom), or \code{Absolute} for Absolute Units}}
}
\value{
the saturation vapor pressure for ice as a numeric vector. The unit
  for \code{SI} and \code{Absolute} is Pascal (Pa), but the unit for \code{Eng}
  is pounds per square inch (psi). The units are not returned.
}
\description{
This function solves for the saturation vapor pressure of ice using only
the temperature of the water in either units of degrees Celsius, degrees
Fahrenheit, or Kelvin.
}
\details{
The simplified equation is expressed as

\deqn{P_s = \exp{\frac{43.494 - \frac{6545.8}{t + 278}}{(t + 868)^2}}}

for (t <= 0 C)

\describe{
  \item{\emph{P_s}}{the saturation vapor pressure (Pa or psi)}
  \item{\emph{t}}{the ice temperature, degrees Celsius}
}
}
\examples{
# Example from the Reference

library(iemisc)

sat_vapor_pressure_ice(Temp = seq(from = -100, to = 0, by = 20), units = "SI")




}
\references{
Huang, J. (2018). "A Simple Accurate Formula for Calculating Saturation Vapor Pressure of Water and Ice", \emph{Journal of Applied Meteorology and Climatology}, 57(6), 1265-1272. Retrieved Nov 4, 2021, \url{https://journals.ametsoc.org/view/journals/apme/57/6/jamc-d-17-0334.1.xml}
}
\author{
Irucka Embry
}
