% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralization.R
\name{centralize}
\alias{centralize}
\alias{centralization}
\alias{centralize.scores}
\title{Centralization of a graph}
\usage{
centralize(scores, theoretical.max = 0, normalized = TRUE)
}
\arguments{
\item{scores}{The vertex level centrality scores.}

\item{theoretical.max}{Real scalar. The graph-level centralization measure of
the most centralized graph with the same number of vertices as the graph
under study. This is only used if the \code{normalized} argument is set
to \code{TRUE}.}

\item{normalized}{Logical scalar. Whether to normalize the graph level
centrality score by dividing by the supplied theoretical maximum.}
}
\value{
A real scalar, the centralization of the graph from which
\code{scores} were derived.
}
\description{
Centralization is a method for creating a graph level centralization
measure from the centrality scores of the vertices.
}
\details{
Centralization is a general method for calculating a graph-level
centrality score based on node-level centrality measure. The formula for
this is
\deqn{C(G)=\sum_v (\max_w c_w - c_v),}{ C(G)=sum(max(c(w), w) - c(v), v),}
where \eqn{c_v}{c(v)} is the centrality of vertex \eqn{v}.

The graph-level centralization measure can be normalized by dividing by the
maximum theoretical score for a graph with the same number of vertices,
using the same parameters, e.g. directedness, whether we consider loop
edges, etc.

For degree, closeness and betweenness the most centralized structure is
some version of the star graph, in-star, out-star or undirected star.

For eigenvector centrality the most centralized structure is the graph
with a single edge (and potentially many isolates).

\code{centralize()} implements general centralization formula to calculate
a graph-level score from vertex-level scores.
}
\examples{
# A BA graph is quite centralized
g <- sample_pa(1000, m = 4)
centr_degree(g)$centralization
centr_clo(g, mode = "all")$centralization
centr_eigen(g, directed = FALSE)$centralization

# Calculate centralization from pre-computed scores
deg <- degree(g)
tmax <- centr_degree_tmax(g, loops = FALSE)
centralize(deg, tmax)

# The most centralized graph according to eigenvector centrality
g0 <- graph(c(2, 1), n = 10, dir = FALSE)
g1 <- make_star(10, mode = "undirected")
centr_eigen(g0)$centralization
centr_eigen(g1)$centralization
}
\references{
Freeman, L.C.  (1979).  Centrality in Social Networks I:
Conceptual Clarification. \emph{Social Networks} 1, 215--239.

Wasserman, S., and Faust, K.  (1994).  \emph{Social Network Analysis:
Methods and Applications.} Cambridge University Press.
}
\seealso{
Other centralization related: 
\code{\link{centr_betw_tmax}()},
\code{\link{centr_betw}()},
\code{\link{centr_clo_tmax}()},
\code{\link{centr_clo}()},
\code{\link{centr_degree_tmax}()},
\code{\link{centr_degree}()},
\code{\link{centr_eigen_tmax}()},
\code{\link{centr_eigen}()}
}
\concept{centralization related}
