% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_in_circle}
\alias{layout_in_circle}
\alias{in_circle}
\title{Graph layout with vertices on a circle.}
\usage{
layout_in_circle(graph, order = V(graph))

in_circle(...)
}
\arguments{
\item{graph}{The input graph.}

\item{order}{The vertices to place on the circle, in the order of their
desired placement. Vertices that are not included here will be placed at
(0,0).}

\item{...}{Passed to \code{layout_in_circle()}.}
}
\value{
A numeric matrix with two columns, and one row for each vertex.
}
\description{
Place vertices on a circle, in the order of their vertex ids.
}
\details{
If you want to order the vertices differently, then permute them using the
\code{\link[=permute]{permute()}} function.
}
\examples{
\dontshow{if (igraph:::has_glpk() && rlang::is_installed("igraphdata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

## Place vertices on a circle, order them according to their
## community
library(igraphdata)
data(karate)
karate_groups <- cluster_optimal(karate)
coords <- layout_in_circle(karate,
  order =
    order(membership(karate_groups))
)
V(karate)$label <- sub("Actor ", "", V(karate)$name)
V(karate)$label.color <- membership(karate_groups)
V(karate)$shape <- "none"
plot(karate, layout = coords)
\dontshow{\}) # examplesIf}
}
\seealso{
Other graph layouts: 
\code{\link{add_layout_}()},
\code{\link{component_wise}()},
\code{\link{layout_}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_grid}()},
\code{\link{layout_on_sphere}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_fr}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_mds}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{merge_coords}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
