% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorbars.R
\name{setup_colorbar_grid}
\alias{setup_colorbar_grid}
\title{setup_colorbar_grid}
\usage{
setup_colorbar_grid(nrows = 3, y_length = y_spacing * 0.9,
  x_spacing = 0.16, y_spacing = y_start/nrows, x_start = 1.05,
  y_start = 0.9)
}
\arguments{
\item{nrows}{number of rows in colorbar grid}

\item{y_length}{length of colorbar}

\item{x_spacing}{spacing along horizonatal axis between colorbars}

\item{y_spacing}{spacing along vertical axis between colorbars}

\item{x_start}{left most position of colorbar grid}

\item{y_start}{top most position of colorbar grid}
}
\value{
\code{\link{IheatmapColorbarGrid-class}} object
}
\description{
function to set parameters controlling colorbar placement in Iheatmap object
}
\examples{

cb_grid <- setup_colorbar_grid(nrows = 2, x_spacing = 0.2)
mat <- matrix(rnorm(24), nrow = 6)
hm <- iheatmap(mat, colorbar_grid = cb_grid, cluster_rows = "kmeans",
         cluster_cols = "kmeans", row_k = 3, col_k = 2)

# Print heatmap if interactive session 
if (interactive()) hm 
}
