% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{as_EBImage}
\alias{as_EBImage}
\title{Convert an \link{ijtiff_img} to an \link[EBImage:Image]{EBImage::Image}.}
\usage{
as_EBImage(img, colormode = NULL, scale = TRUE, force = TRUE)
}
\arguments{
\item{img}{An \link{ijtiff_img} object (or something coercible to one).}

\item{colormode}{A numeric or a character string containing the color mode
which can be either \code{"Grayscale"} or \code{"Color"}. If not specified, a guess
is made. See 'Details'.}

\item{scale}{Scale values in an integer image to the range \verb{[0, 1]}? Has no
effect on floating-point images.}

\item{force}{This function is designed to take \link{ijtiff_img}s as input. To
force any old array through this function, use \code{force = TRUE}, but take
care to check that the result is what you'd like it to be.}
}
\value{
An \link[EBImage:Image]{EBImage::Image}.
}
\description{
This is for interoperability with the the \code{EBImage} package.
}
\details{
The guess for the \code{colormode} is made as follows: * If \code{img} has an attribute
\code{color_space} with value \code{"RGB"}, then \code{colormode} is set to \code{"Color"}. *
Else if \code{img} has 3 or 4 channels, then \code{colormode} is set to \code{"Color"}. *
Else \code{colormode} is set to "Grayscale".
}
\examples{
\dontrun{
img <- read_tif(system.file("img", "Rlogo.tif", package = "ijtiff"))
str(img)
str(as_EBImage(img))
img <- read_tif(system.file("img", "2ch_ij.tif", package = "ijtiff"))
str(img)
str(as_EBImage(img))
}
}
