% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_tags}
\alias{read_tags}
\alias{tags_read}
\title{Read TIFF tag information without actually reading the image array.}
\usage{
read_tags(path, frames = "all", translate_tags = TRUE)

tags_read(path, frames = 1)
}
\arguments{
\item{path}{A string. The path to the tiff file to read.}

\item{frames}{Which frames do you want to read. Default all. To read the 2nd
and 7th frames, use \code{frames = c(2, 7)}.}

\item{translate_tags}{Logical. Should the TIFF tags be translated to
human-readable strings? E.g. \code{Compression = 1} becomes
\code{Compression = "none"}.}
}
\value{
A list of lists.
}
\description{
TIFF files contain metadata about images in their \emph{TIFF tags}. This function
is for reading this information without reading the actual image.
}
\examples{
read_tags(system.file("img", "Rlogo.tif", package = "ijtiff"))
}
\seealso{
\code{\link[=read_tif]{read_tif()}}
}
\author{
Simon Urbanek, Kent Johnson, Rory Nolan.
}
