% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{imsub}
\alias{imsub}
\alias{subim}
\title{Select part of an image}
\usage{
imsub(im, ...)

subim(im, ...)
}
\arguments{
\item{im}{an image}

\item{...}{various conditions defining a rectangular image region}
}
\value{
an image with some parts cut out
}
\description{
imsub selects an image part based on coordinates: it allows you to select a subset of rows, columns, frames etc. Refer to the examples to see how it works
}
\details{
subim is an alias defined for backward-compatibility.
}
\section{Functions}{
\itemize{
\item \code{subim}: alias for imsub
}}
\examples{
parrots <- load.example("parrots")
imsub(parrots,x < 30) #Only the first 30 columns
imsub(parrots,y < 30) #Only the first 30 rows
imsub(parrots,x < 30,y < 30) #First 30 columns and rows
imsub(parrots, sqrt(x) > 8) #Can use arbitrary expressions
imsub(parrots,x > height/2,y > width/2)  #height and width are defined based on the image
imsub(parrots,cc==1) #Colour axis is "cc" not "c" here because "c" is an important R function
##Not run
##imsub(parrots,x+y==1)
##can't have expressions involving interactions between variables (domain might not be square)
}
\author{
Simon Barthelme
}

