# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @describeIn imager.colourspaces RGB to HSL conversion 
#' @export
RGBtoHSL <- function(im) {
    .Call('imager_RGBtoHSL', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces HSL to RGB conversion 
#' @export
HSLtoRGB <- function(im) {
    .Call('imager_HSLtoRGB', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces RGB to HSV conversion 
#' @export
RGBtoHSV <- function(im) {
    .Call('imager_RGBtoHSV', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces HSV to RGB conversion 
#' @export
HSVtoRGB <- function(im) {
    .Call('imager_HSVtoRGB', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces RGB to HSI conversion 
#' @export
RGBtoHSI <- function(im) {
    .Call('imager_RGBtoHSI', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces HSI to RGB conversion 
#' @export
HSItoRGB <- function(im) {
    .Call('imager_HSItoRGB', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces RGB to sRGB conversion 
#' @export
RGBtosRGB <- function(im) {
    .Call('imager_RGBtosRGB', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces sRGB to RGB conversion 
#' @export
sRGBtoRGB <- function(im) {
    .Call('imager_sRGBtoRGB', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces RGB to YCbCr conversion 
#' @export
RGBtoYCbCr <- function(im) {
    .Call('imager_RGBtoYCbCr', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces YCbCr to RGB conversion 
#' @export
YCbCrtoRGB <- function(im) {
    .Call('imager_YCbCrtoRGB', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces RGB to YUV conversion 
#' @export
RGBtoYUV <- function(im) {
    .Call('imager_RGBtoYUV', PACKAGE = 'imager', im)
}

#' @describeIn imager.colourspaces YUV to RGB conversion 
#' @export
YUVtoRGB <- function(im) {
    .Call('imager_YUVtoRGB', PACKAGE = 'imager', im)
}

#' Convert an RGB image to grayscale 
#' 
#' This function converts from RGB to grayscale by first converting to HSL and keeping only the L channel
#' @param im an RGB image 
#' @return a grayscale image (spectrum == 1)
#' @export
grayscale <- function(im) {
    .Call('imager_grayscale', PACKAGE = 'imager', im)
}

getXc <- function(x, y, z, c) {
    .Call('imager_getXc', PACKAGE = 'imager', x, y, z, c)
}

getYc <- function(x, y, z, c) {
    .Call('imager_getYc', PACKAGE = 'imager', x, y, z, c)
}

getZc <- function(x, y, z, c) {
    .Call('imager_getZc', PACKAGE = 'imager', x, y, z, c)
}

getCc <- function(x, y, z, c) {
    .Call('imager_getCc', PACKAGE = 'imager', x, y, z, c)
}

display_ <- function(im, rescale = TRUE) {
    invisible(.Call('imager_display_', PACKAGE = 'imager', im, rescale))
}

display_list <- function(imlist) {
    invisible(.Call('imager_display_list', PACKAGE = 'imager', imlist))
}

#' Play a video 
#'
#' A very basic video player. Press the space bar to pause and ESC to close. 
#' @param vid A cimg object, to be played as video
#' @param loop loop the video (default false)
#' @param delay delay between frames, in ms. Default 30.
#' @param normalise if true pixel values are rescaled to 0...255 (default TRUE). The normalisation is based on the *first frame*. If you don't want the default behaviour you can normalise by hand. Default TRUE.
#' @export
play <- function(vid, loop = FALSE, delay = 30L, normalise = TRUE) {
    invisible(.Call('imager_play', PACKAGE = 'imager', vid, loop, delay, normalise))
}

select <- function(im, type = 2L) {
    .Call('imager_select', PACKAGE = 'imager', im, type)
}

bucket_fill <- function(im, x, y, z, color, opacity = 1, sigma = 0, high_connexity = FALSE) {
    .Call('imager_bucket_fill', PACKAGE = 'imager', im, x, y, z, color, opacity, sigma, high_connexity)
}

bucket_select <- function(im, x, y, z, sigma = 0, high_connexity = FALSE) {
    .Call('imager_bucket_select', PACKAGE = 'imager', im, x, y, z, sigma, high_connexity)
}

#' Apply recursive Deriche filter.
#'
#' The Deriche filter is a fast approximation to a Gaussian filter (order = 0), or Gaussian derivatives (order = 1 or 2).   
#' 
#' @param im an image
#' @param sigma Standard deviation of the filter.
#' @param order Order of the filter. 0 for a smoothing filter, 1 for first-derivative, 2 for second.
#' @param axis Axis along which the filter is computed ( 'x' , 'y', 'z' or 'c').
#' @param neumann If true, use Neumann boundary conditions (default false, Dirichlet)
#' @export
#' @examples
#' deriche(boats,sigma=2,order=0) %>% plot("Zeroth-order Deriche along x")
#' deriche(boats,sigma=2,order=1) %>% plot("First-order Deriche along x")
#' deriche(boats,sigma=2,order=1) %>% plot("Second-order Deriche along x")
#' deriche(boats,sigma=2,order=1,axis="y") %>% plot("Second-order Deriche along y")
deriche <- function(im, sigma, order = 0L, axis = 'x', neumann = FALSE) {
    .Call('imager_deriche', PACKAGE = 'imager', im, sigma, order, axis, neumann)
}

#' Young-Van Vliet recursive Gaussian filter.
#'
#' The Young-van Vliet filter is a fast approximation to a Gaussian filter (order = 0), or Gaussian derivatives (order = 1 or 2).   
#'
#' @param im an image
#' @param sigma standard deviation of the Gaussian filter
#' @param order the order of the filter 0,1,2,3
#' @param axis  Axis along which the filter is computed. Can be <tt>{ 'x' | 'y' | 'z' | 'c' }</tt>.
#' @param neumann If true, use Neumann boundary conditions (default false, Dirichlet)
#' @references
#'       From: I.T. Young, L.J. van Vliet, M. van Ginkel, Recursive Gabor filtering.
#'       IEEE Trans. Sig. Proc., vol. 50, pp. 2799-2805, 2002.
#'       (this is an improvement over Young-Van Vliet, Sig. Proc. 44, 1995)
#'
#'       Boundary conditions (only for order 0) using Triggs matrix, from
#'       B. Triggs and M. Sdika. Boundary conditions for Young-van Vliet
#'       recursive filtering. IEEE Trans. Signal Processing,
#'       vol. 54, pp. 2365-2367, 2006.
#' @examples
#' vanvliet(boats,sigma=2,order=0) %>% plot("Zeroth-order Young-van Vliet along x")
#' vanvliet(boats,sigma=2,order=1) %>% plot("First-order Young-van Vliet along x")
#' vanvliet(boats,sigma=2,order=1) %>% plot("Second-order Young-van Vliet along x")
#' vanvliet(boats,sigma=2,order=1,axis="y") %>% plot("Second-order Young-van Vliet along y")
#' @export
vanvliet <- function(im, sigma, order = 0L, axis = 'x', neumann = FALSE) {
    .Call('imager_vanvliet', PACKAGE = 'imager', im, sigma, order, axis, neumann)
}

#' Blur image isotropically.
#' @param im an image
#' @param sigma Standard deviation of the blur.
#' @param neumann If true, use Neumann boundary conditions, Dirichlet otherwise  (default true, Neumann)
#' @param gaussian Use a Gaussian filter (actually vanVliet-Young). Default: 0th-order Deriche filter.
#' @seealso deriche,vanvliet
#' @export
#' @examples
#' isoblur(boats,3) %>% plot(main="Isotropic blur, sigma=3")
#' isoblur(boats,3) %>% plot(main="Isotropic blur, sigma=10")
#' @seealso medianblur
isoblur <- function(im, sigma, neumann = TRUE, gaussian = FALSE) {
    .Call('imager_isoblur', PACKAGE = 'imager', im, sigma, neumann, gaussian)
}

#' Blur image with the median filter.
#'    
#' In a window of size n x n centered at pixel (x,y), compute median pixel value over the window. Optionally, ignore values that are too far from the value at current pixel.  
#'
#' @param im an image
#' @param n Size of the median filter.
#' @param threshold Threshold used to discard pixels too far from the current pixel value in the median computation. Can be used for edge-preserving smoothing. Default 0 (include all pixels in window).
#' @export
#' @examples
#' medianblur(boats,5) %>% plot(main="Median blur, 5 pixels")
#' medianblur(boats,10) %>% plot(main="Median blur, 10 pixels")
#' medianblur(boats,10,8) %>% plot(main="Median blur, 10 pixels, threshold = 8")
#' @seealso isoblur, boxblur
medianblur <- function(im, n, threshold = 0) {
    .Call('imager_medianblur', PACKAGE = 'imager', im, n, threshold)
}

#' Blur image with a box filter (square window)
#' @param im an image
#' @param sigma Size of the box window.
#' @param neumann If true, use Neumann boundary conditions, Dirichlet otherwise  (default true, Neumann)
#' @seealso deriche(), vanvliet().
#' @examples
#' boxblur(boats,5) %>% plot(main="Dirichlet boundary")
#' boxblur(boats,5,TRUE) %>% plot(main="Neumann boundary")
#' @export
boxblur <- function(im, sigma, neumann = TRUE) {
    .Call('imager_boxblur', PACKAGE = 'imager', im, sigma, neumann)
}

#' Blur image with a box filter.
#'
#' This is a recursive algorithm, not depending on the values of the box kernel size.
#'
#' @param im an image
#' @param sx Size of the box window, along the X-axis.
#' @param sy Size of the box window, along the Y-axis.
#' @param neumann If true, use Neumann boundary conditions, Dirichlet otherwise  (default true, Neumann)
#' @seealso blur().
#'
#' @export
#' @examples
#' boxblur_xy(boats,20,5) %>% plot(main="Anisotropic blur")
boxblur_xy <- function(im, sx, sy, neumann = TRUE) {
    .Call('imager_boxblur_xy', PACKAGE = 'imager', im, sx, sy, neumann)
}

#' Correlation of image by filter
#'
#'  The correlation of image im by filter flt is defined as:
#'  \eqn{res(x,y,z) = sum_{i,j,k} im(x + i,y + j,z + k)*flt(i,j,k).}
#'
#' @param im an image
#' @param filter the correlation kernel.
#' @param dirichlet boundary condition (FALSE=zero padding, TRUE=dirichlet). Default FALSE
#' @param normalise normalise filter (default FALSE)
#'      
#'
#' @export
#' @examples
#' #Edge filter
#' filter <- as.cimg(function(x,y) sign(x-5),10,10) 
#' layout(t(1:2))
#' #Convolution vs. correlation 
#' correlate(boats,filter) %>% plot(main="Correlation")
#' convolve(boats,filter) %>% plot(main="Convolution")
correlate <- function(im, filter, dirichlet = FALSE, normalise = FALSE) {
    .Call('imager_correlate', PACKAGE = 'imager', im, filter, dirichlet, normalise)
}

#' Convolve image by filter.
#'
#'      The result  res of the convolution of an image img by filter flt is defined to be:
#'       \eqn{res(x,y,z) = sum_{i,j,k} img(x-i,y-j,z-k)*flt(i,j,k)}
#'
#' @param im an image
#' @param filter a filter (another image)
#' @param dirichlet boundary condition (FALSE=zero padding, TRUE=dirichlet). Default FALSE
#' @param normalise normalise filter (default FALSE)
#' @export
#' @seealso correlate
#' @examples
#' #Edge filter
#' filter <- as.cimg(function(x,y) sign(x-5),10,10) 
#' layout(t(1:2))
#' #Convolution vs. correlation 
#' correlate(boats,filter) %>% plot(main="Correlation")
#' convolve(boats,filter) %>% plot(main="Convolution")
convolve <- function(im, filter, dirichlet = FALSE, normalise = FALSE) {
    .Call('imager_convolve', PACKAGE = 'imager', im, filter, dirichlet, normalise)
}

sharpen <- function(im, amplitude, sharpen_type = FALSE, edge = 1, alpha = 0, sigma = 0) {
    .Call('imager_sharpen', PACKAGE = 'imager', im, amplitude, sharpen_type, edge, alpha, sigma)
}

#' Compute image gradient.
#'
#' @param im an image
#' @param axes Axes considered for the gradient computation, as a C-string (e.g "xy").
#' @param scheme = Numerical scheme used for the gradient computation:
#'       1 = Backward finite differences
#'       0 = Centered finite differences
#'       1 = Forward finite differences
#'       2 = Using Sobel masks
#'       3 = Using rotation invariant masks
#'       4 = Using Deriche recursive filter.
#'       5 = Using Van Vliet recursive filter.
#' @return a list of images (corresponding to the different directions)
#' @export
#' @seealso imgradient
get_gradient <- function(im, axes = "", scheme = 3L) {
    .Call('imager_get_gradient', PACKAGE = 'imager', im, axes, scheme)
}

#' Return image hessian.
#' @param im an image
#' @param axes Axes considered for the hessian computation, as a character string (e.g "xy").
get_hessian <- function(im, axes = "") {
    .Call('imager_get_hessian', PACKAGE = 'imager', im, axes)
}

#' Compute field of diffusion tensors for edge-preserving smoothing.
#'
#' @param im an image
#' @param sharpness Sharpness
#' @param anisotropy Anisotropy
#' @param alpha Standard deviation of the gradient blur.
#' @param sigma Standard deviation of the structure tensor blur.
#' @param is_sqrt Tells if the square root of the tensor field is computed instead.
#' @export
diffusion_tensors <- function(im, sharpness = 0.7, anisotropy = 0.6, alpha = 0.6, sigma = 1.1, is_sqrt = FALSE) {
    .Call('imager_diffusion_tensors', PACKAGE = 'imager', im, sharpness, anisotropy, alpha, sigma, is_sqrt)
}

#' Compute Haar multiscale wavelet transform.
#'
#' @param im an image
#' @param inverse Compute inverse transform (default FALSE)
#' @param nb_scales Number of scales used for the transform.
#' @export
#' @examples
#' #Image compression: set small Haar coefficients to 0
#' hr <- haar(boats,nb=3) 
#' mask.low <- threshold(abs(hr),"75%")
#' mask.high <- threshold(abs(hr),"95%")
#' haar(hr*mask.low,inverse=TRUE,nb=3) %>% plot(main="75% compression")
#' haar(hr*mask.high,inverse=TRUE,nb=3) %>% plot(main="95% compression")
haar <- function(im, inverse = FALSE, nb_scales = 1L) {
    .Call('imager_haar', PACKAGE = 'imager', im, inverse, nb_scales)
}

FFT_complex <- function(real, imag, inverse = FALSE, nb_threads = 0L) {
    .Call('imager_FFT_complex', PACKAGE = 'imager', real, imag, inverse, nb_threads)
}

FFT_realim <- function(real, inverse = FALSE, nb_threads = 0L) {
    .Call('imager_FFT_realim', PACKAGE = 'imager', real, inverse, nb_threads)
}

FFT_realout <- function(real, imag, inverse = FALSE, nb_threads = 0L) {
    .Call('imager_FFT_realout', PACKAGE = 'imager', real, imag, inverse, nb_threads)
}

#' Estimate displacement field between two images.
#'
#' @param sourceIm Reference image.
#' @param destIm Reference image.
#' @param smoothness Smoothness of estimated displacement field.
#' @param precision Precision required for algorithm convergence.
#' @param nb_scales Number of scales used to estimate the displacement field.
#' @param iteration_max Maximum number of iterations allowed for one scale.
#' @param is_backward If false, match I2(X + U(X)) = I1(X), else match I2(X) = I1(X - U(X)).
#' @export
displacement <- function(sourceIm, destIm, smoothness = 0.1, precision = 5.0, nb_scales = 0L, iteration_max = 10000L, is_backward = FALSE) {
    .Call('imager_displacement', PACKAGE = 'imager', sourceIm, destIm, smoothness, precision, nb_scales, iteration_max, is_backward)
}

#' Blur image anisotropically, in an edge-preserving way.
#' 
#' Standard blurring removes noise from images, but tends to smooth away edges in the process. This anisotropic filter preserves edges better. 
#' 
#' @param im an image
#' @param amplitude Amplitude of the smoothing.
#' @param sharpness Sharpness.
#' @param anisotropy Anisotropy.
#' @param alpha Standard deviation of the gradient blur.
#' @param sigma Standard deviation of the structure tensor blur.
#' @param dl Spatial discretization.
#' @param da Angular discretization.
#' @param gauss_prec Precision of the diffusion process.
#' @param interpolation_type Interpolation scheme.
#'  Can be 0=nearest-neighbor | 1=linear | 2=Runge-Kutta 
#' @param fast_approx If true, use fast approximation (default TRUE)
#' @export
#' @examples
#' im <- load.image(system.file('extdata/Leonardo_Birds.jpg',package='imager'))
#' im.noisy <- (im + 80*rnorm(prod(dim(im)))) 
#' blur_anisotropic(im.noisy,ampl=1e4,sharp=1) %>% plot
blur_anisotropic <- function(im, amplitude, sharpness = 0.7, anisotropy = 0.6, alpha = 0.6, sigma = 1.1, dl = 0.8, da = 30, gauss_prec = 2, interpolation_type = 0L, fast_approx = TRUE) {
    .Call('imager_blur_anisotropic', PACKAGE = 'imager', im, amplitude, sharpness, anisotropy, alpha, sigma, dl, da, gauss_prec, interpolation_type, fast_approx)
}

periodic_part <- function(im) {
    .Call('imager_periodic_part', PACKAGE = 'imager', im)
}

interp_xy <- function(inp, ix, iy, z = 0L, c = 0L, cubic = FALSE) {
    .Call('imager_interp_xy', PACKAGE = 'imager', inp, ix, iy, z, c, cubic)
}

interp_xyz <- function(inp, ix, iy, iz, c = 0L, cubic = FALSE) {
    .Call('imager_interp_xyz', PACKAGE = 'imager', inp, ix, iy, iz, c, cubic)
}

interp_xyzc <- function(inp, ix, iy, iz, ic, cubic = FALSE) {
    .Call('imager_interp_xyzc', PACKAGE = 'imager', inp, ix, iy, iz, ic, cubic)
}

interp_xyc <- function(inp, ix, iy, z, ic, cubic = FALSE) {
    .Call('imager_interp_xyc', PACKAGE = 'imager', inp, ix, iy, z, ic, cubic)
}

#' Label connected components.
#'
#' The algorithm of connected components computation has been primarily done
#'by A. Meijster, according to the publication:
#''W.H. Hesselink, A. Meijster, C. Bron, "Concurrent Determination of Connected Components.",
#'       In: Science of Computer Programming 41 (2001), pp. 173--194'.
#'
#' @param im an image
#' @param high_connectivity   4(false)- or 8(true)-connectivity
#'       in 2d case, and between 6(false)- or 26(true)-connectivity in 3d case. Default FALSE
#' @param tolerance Tolerance used to determine if two neighboring pixels belong to the same region.
#' @export
#' @examples
#' imname <- system.file('extdata/parrots.png',package='imager')
#' im <- load.image(imname) %>% grayscale
#' #Thresholding yields different discrete regions of high intensity
#' regions <- isoblur(im,10) %>% threshold("97%") 
#' labels <- label(regions)
#' layout(t(1:2))
#' plot(regions,"Regions")
#' plot(labels,"Labels")
#' 
label <- function(im, high_connectivity = FALSE, tolerance = 0) {
    .Call('imager_label', PACKAGE = 'imager', im, high_connectivity, tolerance)
}

#' Erode/dilate image by a structuring element.
#'
#' @param im an image
#' @param size size of the structuring element.
#' @param mask Structuring element.
#' @param boundary_conditions Boundary conditions.
#' @param normalise Determines if the closing is locally normalised (default FALSE)
#' @export
#' @examples
#' fname <- system.file('extdata/Leonardo_Birds.jpg',package='imager')
#' im <- load.image(fname) %>% grayscale
#' outline <- threshold(-im,"95%")
#' plot(outline)
#' mask <- imfill(5,10,val=1) #Rectangular mask
#' plot(erode(outline,mask))
#' plot(erode_rect(outline,5,10)) #Same thing
#' plot(erode_square(outline,5)) 
#' plot(dilate(outline,mask))
#' plot(dilate_rect(outline,5,10))
#' plot(dilate_square(outline,5)) 
erode <- function(im, mask, boundary_conditions = TRUE, normalise = FALSE) {
    .Call('imager_erode', PACKAGE = 'imager', im, mask, boundary_conditions, normalise)
}

#' @describeIn erode Erode image by a rectangular structuring element of specified size.
#' @param sx Width of the structuring element.
#' @param sy Height of the structuring element.
#' @param sz Depth of the structuring element.
#' @export
erode_rect <- function(im, sx, sy, sz = 1L) {
    .Call('imager_erode_rect', PACKAGE = 'imager', im, sx, sy, sz)
}

#' @describeIn erode Erode image by a square structuring element of specified size.
#'
#' @export
erode_square <- function(im, size) {
    .Call('imager_erode_square', PACKAGE = 'imager', im, size)
}

#' @describeIn erode Dilate image by a structuring element.
#' @export
dilate <- function(im, mask, boundary_conditions = TRUE, normalise = FALSE) {
    .Call('imager_dilate', PACKAGE = 'imager', im, mask, boundary_conditions, normalise)
}

#' @describeIn erode Dilate image by a rectangular structuring element of specified size
#' @export
dilate_rect <- function(im, sx, sy, sz = 1L) {
    .Call('imager_dilate_rect', PACKAGE = 'imager', im, sx, sy, sz)
}

#' @describeIn erode Dilate image by a square structuring element of specified size
#' @export
dilate_square <- function(im, size) {
    .Call('imager_dilate_square', PACKAGE = 'imager', im, size)
}

#' Compute watershed transform.
#'
#' The watershed transform is a label propagation algorithm. The value of non-zero pixels will get propagated to their zero-value neighbours. The propagation is controlled by a priority map. See examples. 
#' @param im an image
#' @param priority Priority map.
#' @param fill_lines Sets if watershed lines must be filled or not.
#' @examples
#' #In our initial image we'll place three seeds 
#' #(non-zero pixels) at various locations, with values 1, 2 and 3. 
#' #We'll use the watershed algorithm to propagate these values
#' imd <- function(x,y) imdirac(c(100,100,1,1),x,y)
#' im <- imd(20,20)+2*imd(40,40)+3*imd(80,80)
#' layout(t(1:3))
#' plot(im,main="Seed image")
#' #Now we build an priority map: neighbours of our seeds 
#' #should get high priority. 
#' #We'll use a distance map for that
#' p <- 1-distance_transform(sign(im),1) 
#' plot(p,main="Priority map")
#' watershed(im,p) %>% plot(main="Watershed transform")
#' @export
watershed <- function(im, priority, fill_lines = TRUE) {
    .Call('imager_watershed', PACKAGE = 'imager', im, priority, fill_lines)
}

#' Compute Euclidean distance function to a specified value.
#'
#'        The distance transform implementation has been submitted by A. Meijster, and implements
#'        the article 'W.H. Hesselink, A. Meijster, J.B.T.M. Roerdink,
#'                     "A general algorithm for computing distance transforms in linear time.",
#'                     In: Mathematical Morphology and its Applications to Image and Signal Processing,
#'                     J. Goutsias, L. Vincent, and D.S. Bloomberg (eds.), Kluwer, 2000, pp. 331-340.'
#'         The submitted code has then been modified to fit CImg coding style and constraints.
#' @param im an image
#' @param value Reference value.
#' @param metric Type of metric. Can be <tt>{ 0=Chebyshev | 1=Manhattan | 2=Euclidean | 3=Squared-euclidean }</tt>.
#' @export
#' @examples
#' imd <- function(x,y) imdirac(c(100,100,1,1),x,y)
#' #Image is three white dots
#' im <- imd(20,20)+imd(40,40)+imd(80,80)
#' plot(im)
#' #How far are we from the nearest white dot? 
#' distance_transform(im,1) %>% plot
distance_transform <- function(im, value, metric = 2L) {
    .Call('imager_distance_transform', PACKAGE = 'imager', im, value, metric)
}

#' @describeIn erode Morphological opening (erosion followed by dilation)
#' @export
mopening <- function(im, mask, boundary_conditions = TRUE, normalise = FALSE) {
    .Call('imager_mopening', PACKAGE = 'imager', im, mask, boundary_conditions, normalise)
}

#' @describeIn erode Morphological opening by a square element (erosion followed by dilation)
#' @export
mopening_square <- function(im, size) {
    .Call('imager_mopening_square', PACKAGE = 'imager', im, size)
}

#' @describeIn erode Morphological closing by a square element (dilation followed by erosion)
#' @export
mclosing_square <- function(im, size) {
    .Call('imager_mclosing_square', PACKAGE = 'imager', im, size)
}

#' @describeIn erode Morphological closing (dilation followed by erosion)
#' @export
mclosing <- function(im, mask, boundary_conditions = TRUE, normalise = FALSE) {
    .Call('imager_mclosing', PACKAGE = 'imager', im, mask, boundary_conditions, normalise)
}

autocrop_ <- function(im, color, axes = "zyx") {
    .Call('imager_autocrop_', PACKAGE = 'imager', im, color, axes)
}

#' Rotate image by an arbitrary angle.
#'
#' Most of the time, the size of the image is modified.
#'
#' @param im an image
#' @param angle Rotation angle, in degrees.
#' @param interpolation Type of interpolation. Can be <tt>{ 0=nearest | 1=linear | 2=cubic }</tt>.
#' @param boundary Boundary conditions. Can be <tt>{  0=dirichlet | 1=neumann | 2=periodic }</tt>.
#' @export
imrotate <- function(im, angle, interpolation = 1L, boundary = 0L) {
    .Call('imager_imrotate', PACKAGE = 'imager', im, angle, interpolation, boundary)
}

#' Rotate image by an arbitrary angle, around a center point.
#'
#' @param im an image
#' @param angle Rotation angle, in degrees.
#' @param cx X-coordinate of the rotation center.
#' @param cy Y-coordinate of the rotation center.
#' @param zoom Zoom factor.
#' @param interpolation Interpolation type. 0=nearest | 1=linear | 2=cubic 
#' @param boundary_conditions Boundary conditions. 0=dirichlet | 1=neumann | 2=periodic 
#' @examples
#' rotate_xy(boats,30,200,400) %>% plot
#' rotate_xy(boats,30,200,400,boundary=2) %>% plot
#' @export
rotate_xy <- function(im, angle, cx, cy, zoom = 1, interpolation = 1L, boundary_conditions = 0L) {
    .Call('imager_rotate_xy', PACKAGE = 'imager', im, angle, cx, cy, zoom, interpolation, boundary_conditions)
}

#' Mirror image content along specified axis 
#' @param im an image
#' @param axis Mirror axis ("x","y","z","c")
#' @export
#' @examples
#' mirror(boats,"x") %>% plot
#' mirror(boats,"y") %>% plot
mirror <- function(im, axis) {
    .Call('imager_mirror', PACKAGE = 'imager', im, axis)
}

#' Permute image axes
#' 
#' By default images are stored in xyzc order. Use permute_axes to change that order. 
#' @param im an image
#' @param perm a character string, e.g., "zxyc" to have the z-axis come first
#' @export
#' @examples
#' im <- array(0,c(10,30,40,3)) %>% as.cimg
#' permute_axes(im,"zxyc")
permute_axes <- function(im, perm) {
    .Call('imager_permute_axes', PACKAGE = 'imager', im, perm)
}

#' @describeIn resize_uniform Double size
#' @export
resize_doubleXY <- function(im) {
    .Call('imager_resize_doubleXY', PACKAGE = 'imager', im)
}

#' @describeIn resize_uniform Half size
#' @export
resize_halfXY <- function(im) {
    .Call('imager_resize_halfXY', PACKAGE = 'imager', im)
}

#' @describeIn resize_uniform Triple size
#' @export
resize_tripleXY <- function(im) {
    .Call('imager_resize_tripleXY', PACKAGE = 'imager', im)
}

#' Shift image content.
#'
#' @param im an image
#' @param delta_x Amount of displacement along the X-axis.
#' @param delta_y Amount of displacement along the Y-axis.
#' @param delta_z Amount of displacement along the Z-axis.
#' @param delta_c Amount of displacement along the C-axis.
#' @param boundary_conditions can be:
#'          - 0: Zero border condition (Dirichlet).
#'          - 1: Nearest neighbors (Neumann).
#'          - 2: Repeat Pattern (Fourier style).
#' @export
#' @examples
#' imshift(boats,10,50) %>% plot
imshift <- function(im, delta_x = 0L, delta_y = 0L, delta_z = 0L, delta_c = 0L, boundary_conditions = 0L) {
    .Call('imager_imshift', PACKAGE = 'imager', im, delta_x, delta_y, delta_z, delta_c, boundary_conditions)
}

#' Resize image to new dimensions.
#' If pd[x,y,z,v]<0, it corresponds to a percentage of the original size (the default value is -100).
#' @param im an image
#' @param size_x Number of columns (new size along the X-axis).
#' @param size_y Number of rows (new size along the Y-axis).
#' @param size_z Number of slices (new size along the Z-axis).
#' @param size_c Number of vector-channels (new size along the C-axis).
#' @param interpolation_type Method of interpolation:
#' -1 = no interpolation: raw memory resizing.
#' 0 = no interpolation: additional space is filled according to  boundary_conditions.
#' 1 = nearest-neighbor interpolation.
#' 2 = moving average interpolation.
#' 3 = linear interpolation.
#' 4 = grid interpolation.
#' 5 = cubic interpolation.
#' 6 = lanczos interpolation.
#' @param boundary_conditions Border condition type.
#' @param centering_x Set centering type (only if  interpolation_type=0).
#' @param centering_y Set centering type (only if  interpolation_type=0).
#' @param centering_z Set centering type (only if  interpolation_type=0).
#' @param centering_c Set centering type (only if  interpolation_type=0).
#' @export
resize <- function(im, size_x = -100L, size_y = -100L, size_z = -100L, size_c = -100L, interpolation_type = 1L, boundary_conditions = 0L, centering_x = 0, centering_y = 0, centering_z = 0, centering_c = 0) {
    .Call('imager_resize', PACKAGE = 'imager', im, size_x, size_y, size_z, size_c, interpolation_type, boundary_conditions, centering_x, centering_y, centering_z, centering_c)
}

#' Warp image
#'
#' @param im an image
#' @param warpfield Warping field. The (x,y,z) fields should be stacked along the colour coordinate. 
#' @param mode Can be { 0=backward-absolute | 1=backward-relative | 2=forward-absolute | 3=forward-relative }
#' @param interpolation Can be <tt>{ 0=nearest | 1=linear | 2=cubic }</tt>.
#' @param boundary_conditions Boundary conditions. Can be <tt>{ 0=dirichlet | 1=neumann | 2=periodic }</tt>.
#' @seealso imwarp for a user-friendly interface 
#' @export
#' @examples
#' #Shift image via warp
#' warp.x <- imfill(width(boats),height(boats),val=5)
#' warp.y <- imfill(width(boats),height(boats),val=20)
#' warpfield <- list(warp.x,warp.y) %>% imappend("c")
#' warp(boats,warpfield,mode=1) %>% plot
warp <- function(im, warpfield, mode = 0L, interpolation = 1L, boundary_conditions = 0L) {
    .Call('imager_warp', PACKAGE = 'imager', im, warpfield, mode, interpolation, boundary_conditions)
}

load_image <- function(fname) {
    .Call('imager_load_image', PACKAGE = 'imager', fname)
}

save_image <- function(im, fname) {
    invisible(.Call('imager_save_image', PACKAGE = 'imager', im, fname))
}

#' Split an image along a certain axis (producing a list)
#' 
#' @param im an image 
#' @param axis the axis along which to split (for example 'c')
#' @param nb number of objects to split into. 
#' if nb=-1 (the default) the maximum number of splits is used ie. split(im,"c") produces a list containing all individual colour channels
#' @seealso imappend (the reverse operation)
im_split <- function(im, axis, nb = -1L) {
    .Call('imager_im_split', PACKAGE = 'imager', im, axis, nb)
}

#' Combine a list of images into a single image 
#' 
#' All images will be concatenated along the x,y,z, or c axis.
#' 
#' @param imlist a list of images (all elements must be of class cimg) 
#' @param axis the axis along which to concatenate (for example 'c')
#' @seealso imsplit (the reverse operation)
#' @export
#' @examples
#' imappend(list(boats,boats),"x") %>% plot
#' imappend(list(boats,boats),"y") %>% plot
#' plyr::rlply(3,imnoise(100,100)) %>% imappend("c") %>% plot
#' boats.gs <- grayscale(boats)
#' plyr::llply(seq(1,5,l=3),function(v) isoblur(boats.gs,v)) %>% imappend("c") %>% plot
imappend <- function(imlist, axis) {
    .Call('imager_imappend', PACKAGE = 'imager', imlist, axis)
}

#' Pixel-wise evaluation of a CImg expression
#'
#' This function provides experimental support for CImg's "math expression parser", a byte-compiled mini-language. 
#' @param im an image
#' @param expr an expression (as string)
#' @examples
#' imfill(10,10) %>% imeval('x+y') %>% plot
#' # Box filter
#' boxf = "v=0;for(iy=y-3,iy<y+3,iy++,for(ix=x-3,ix< x+3,ix++,v+=i(ix,iy)));v"
#' imeval(boats,boxf) %>% plot
#' # Example by D. Tschumperle: Julia set
#' julia <-  "
#'    zr = -1.2 + 2.4*x/w;
#'    zi = -1.2 + 2.4*y/h;
#'    for (iter = 0, zr^2+zi^2<=4 && iter<256, iter++,
#'      t = zr^2 - zi^2 + 0.5;
#'      (zi *= 2*zr) += 0.2;
#'      zr = t
#'    );
#'    iter"
#' imfill(500,500) %>% imeval(julia) %>% plot
#' @export
imeval <- function(im, expr) {
    .Call('imager_imeval', PACKAGE = 'imager', im, expr)
}

#' Extract a numerical summary from image patches, using CImg's mini-language
#' Experimental feature. 
#' @param im an image
#' @param expr a CImg expression (as a string)
#' @param cx vector of x coordinates for patch centers 
#' @param cy vector of y coordinates for patch centers 
#' @param wx vector of coordinates for patch width 
#' @param wy vector of coordinates for patch height 
#' @examples
#' #Example: median filtering using patch_summary_cimg
#' #Center a patch at each pixel
#' im <- grayscale(boats)
#' patches <- pixel.grid(im)  %>% mutate(w=3,h=3)
#' #Extract patch summary
#' out <- mutate(patches,med=patch_summary_cimg(im,"ic",x,y,w,h))
#' as.cimg(out,v.name="med") %>% plot
#' @export
patch_summary_cimg <- function(im, expr, cx, cy, wx, wy) {
    .Call('imager_patch_summary_cimg', PACKAGE = 'imager', im, expr, cx, cy, wx, wy)
}

extract_fast <- function(im, fun, cx, cy, wx, wy) {
    .Call('imager_extract_fast', PACKAGE = 'imager', im, fun, cx, cy, wx, wy)
}

#' Extract image patches and return a list
#'
#' Patches are rectangular (cubic) image regions centered at cx,cy (cz) with width wx and height wy (opt. depth wz)
#' WARNINGS: 
#' - values outside of the image region are considered to be 0.
#' - widths and heights should be odd integers (they're rounded up otherwise). 
#' @param im an image
#' @param cx vector of x coordinates for patch centers 
#' @param cy vector of y coordinates for patch centers 
#' @param wx vector of patch widths (or single value)
#' @param wy vector of patch heights (or single value)
#' @return a list of image patches (cimg objects)
#' @export
#' @examples
#' #2 patches of size 5x5 located at (10,10) and (10,20)
#' extract_patches(boats,c(10,10),c(10,20),5,5)
extract_patches <- function(im, cx, cy, wx, wy) {
    .Call('imager_extract_patches', PACKAGE = 'imager', im, cx, cy, wx, wy)
}

#' @param cz vector of z coordinates for patch centers 
#' @param wz vector of coordinates for patch depth
#' @describeIn extract_patches Extract 3D patches
#' @export
extract_patches3D <- function(im, cx, cy, cz, wx, wy, wz) {
    .Call('imager_extract_patches3D', PACKAGE = 'imager', im, cx, cy, cz, wx, wy, wz)
}

draw_image <- function(im, sprite, x = 0L, y = 0L, z = 0L, opacity = 1) {
    .Call('imager_draw_image', PACKAGE = 'imager', im, sprite, x, y, z, opacity)
}

do_patchmatch <- function(im1, im2, patch_width, patch_height, patch_depth, nb_iterations, nb_randoms, guide) {
    .Call('imager_do_patchmatch', PACKAGE = 'imager', im1, im2, patch_width, patch_height, patch_depth, nb_iterations, nb_randoms, guide)
}

checkcoords <- function(x, y, z, c, d) {
    .Call('imager_checkcoords', PACKAGE = 'imager', x, y, z, c, d)
}

cimg_omp <- function() {
    .Call('imager_cimg_omp', PACKAGE = 'imager')
}

set_cimg_omp <- function(mode) {
    .Call('imager_set_cimg_omp', PACKAGE = 'imager', mode)
}

has_omp <- function() {
    .Call('imager_has_omp', PACKAGE = 'imager')
}

