% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitcombine.R
\name{imappend}
\alias{imappend}
\title{Combine a list of images into a single image}
\usage{
imappend(imlist, axis)
}
\arguments{
\item{imlist}{a list of images (all elements must be of class cimg)}

\item{axis}{the axis along which to concatenate (for example 'c')}
}
\description{
All images will be concatenated along the x,y,z, or c axis.
}
\examples{
imappend(list(boats,boats),"x") \%>\% plot
imappend(list(boats,boats),"y") \%>\% plot
purrr::map(1:3, ~imnoise(100,100)) \%>\% imappend("c") \%>\% plot
boats.gs <- grayscale(boats)
purrr::map(seq(1,5,l=3),function(v) isoblur(boats.gs,v)) \%>\% imappend("c") \%>\% plot
#imappend also works on pixsets
imsplit(boats > .5,"c") \%>\% imappend("x") \%>\% plot
}
\seealso{
imsplit (the reverse operation)
}
