% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagine-main.R
\name{convolution2D}
\alias{convolution2D}
\alias{convolutionQuantile}
\alias{convolutionMedian}
\title{Make convolution calculations from numeric matrix}
\usage{
convolution2D(dataMatrix, kernel, times = 1)

convolutionQuantile(dataMatrix, kernel, x, times = 1)

convolutionMedian(dataMatrix, kernel, times = 1)
}
\arguments{
\item{dataMatrix}{A \code{numeric matrix} object used for apply filters.}

\item{kernel}{A little matrix used as mask for each cell of \code{dataMatrix}.}

\item{times}{How many times do you want to apply the filter?}

\item{x}{\code{numeric} vector of probabilities with values in [0,1].}
}
\value{
\code{convolution2D} returns a \code{matrix} object with the same dimensions of \code{dataMatrix}.

\code{convolutionQuantile} uses the kernel but, for each cell, it returns the position
of quantile 'x' (value between 0 and 1).

\code{convolutionMedian} is a wrapper of \code{convolutionQuantile} with x = 0.5.
}
\description{
This function takes a \code{matrix} object, and for each cell multiplies its neighborhood by
the \code{kernel}. Finally, it returns for each cell the mean of the kernel-weighted sum.
}
\details{
Convolution is a  mathematical operation which allows the multiplication of two arrays of numbers, in order
to produce an array of numbers of the same dimensionality. Functions use C++ algorithms. More details are shown in vignette.
}
\examples{
# Generate example matrix
nRows <- 50
nCols <- 100

myMatrix <- matrix(runif(nRows*nCols, 0, 100), nrow = nRows, ncol = nCols)
kernel <- diag(3)

# Make convolution
myOutput1 <- convolution2D(myMatrix, kernel)
myOutput2 <- convolutionQuantile(myMatrix, kernel, x = 0.7)

# Plot results
par(mfrow = c(2, 2))
image(myMatrix, zlim = c(0, 100))
image(myOutput1, zlim = c(0, 100))
image(myOutput2, zlim = c(0, 100))
}
