% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis}
\alias{vis}
\title{One function to visualise them all}
\usage{
vis(.data, ...)
}
\arguments{
\item{.data}{Pass the output from any immunarch analysis tool to \code{vis()}.}

\item{...}{Any other arguments, see the "Details" section for specific visualisation functions.}
}
\value{
A ggplot2, pheatmap or circlize object.
}
\description{
Output from every function in immunarch can be visualised with a
single function - \code{vis}. The \code{vis} automatically detects
the type of the data and draws a proper visualisation. For example, output
from the \code{repOverlap} function will be identified as repertoire overlap values
and respective visualisation will be chosen without any additional arguments.
See "Details" for the list of available visualisations.
}
\details{
List of available visualisations for different kinds of data.

Basic analysis:

- Exploratory analysis results (from \link{repExplore}) - see \link{vis.immunr_exp_vol};

- Clonality statistics (from \link{repClonality}) - see \link{vis.immunr_homeo}.

Overlaps and public clonotypes:

- Overlaps (from \link{repOverlap}) using heatmaps, circos plots, polar area plots - see \link{vis.immunr_ov_matrix};

-  Overlap clustering (from \link{repOverlapAnalysis}) - see \link{vis.immunr_hclust};

- Repertoire incremental overlaps (from \link{repOverlap}) - see \link{vis.immunr_inc_overlap};

- Public repertoire abundance (from \link{pubRep}) - vis \link{vis.immunr_public_repertoire}.

Gene usage:

- Gene usage statistics (from \link{geneUsage}) using bar plots, box plots, treemaps - see \link{vis.immunr_gene_usage};

- Gene usage distances (from \link{geneUsageAnalysis}) using heatmaps, circos plots, polar area plots - see \link{vis.immunr_ov_matrix};

- Gene usage clustering (from \link{geneUsageAnalysis}) - see \link{vis.immunr_hclust}.

Diversity estimation:

- Diversity estimations (from \link{repDiversity}) - see \link{vis.immunr_chao1}.

Advanced analysis:

- Repertoire dynamics (from \link{trackClonotypes}) - see \link{vis.immunr_dynamics};

- Sequence logo plots of amino acid distributions (from \link{kmer_profile}) - see \link{vis_seqlogo};

- Kmers distributions (from \link{getKmers}) - see \link{vis.immunr_kmer_table};

- Mutation networks (from mutationNetwork) - Work In Progress on vis.immunr_mutation_network;

- CDR3 amino acid properties, e.g., biophysical (from cdrProp) - Work In Progress on vis.immunr_cdr_prop.

Additionaly, we provide a wrapper functions for visualisations of common data types:

- Any data frames or matrices using heatmaps - see \link{vis_heatmap} and \link{vis_heatmap2};

- Any data frames or matrices using circos plots - see \link{vis_circos}.
}
\examples{
# Load the test data
data(immdata)

# Compute and visualise:
ov <- repOverlap(immdata$data)
vis(ov)

gu <- geneUsage(immdata$data)
vis(gu)

dv <- repDiversity(immdata$data)
vis(dv)
}
\seealso{
\link{fixVis} for precise manipulation of plots.
}
\concept{vis}
