% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_wear.R
\name{detect_nonwear}
\alias{detect_nonwear}
\title{Detection of accelerometer non-wear time}
\usage{
detect_nonwear(data, window1, window2, threshold)
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{window1, window2}{Windows size, in minutes, for the non-wear
detection algorithm. \code{window2} must be smaller than \code{window1},
and \code{window1} must be a multiple of \code{window2}.}

\item{threshold}{Number of axes that need to meet the non-wear criteria.}
}
\value{
A named list of length 2 (stage1 and stage2) containing the binary
non-wear classification (0 is wear and 1 is non-wear) of each algorithm's
stage per \code{window2} blocks.
}
\description{
Implementation of the van Hees algorithm of non-wear detection.
}
\details{
This is an internal function, designed to be used inside the wrapper
function \link[=remove_nonwear]{remove_nonwear()} that integrates all
steps of detection, removal and inspection of accelerometer non-wear time.
}
\seealso{
\code{\link[=plot_nonwear]{plot_nonwear()}},
\code{\link[=mark_nonwear]{mark_nonwear()}},
\code{\link[=summarise_nonwear]{summarise_nonwear()}},
\code{\link[=delete_nonwear]{delete_nonwear()}}
}
\keyword{internal}
