% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IATrel.R
\name{IATrel}
\alias{IATrel}
\title{IAT reliability}
\usage{
IATrel(data)
}
\arguments{
\item{data}{dataframe with class \code{"dscore"} (Gawronski et al., 2017).}
}
\value{
List of two objects:
   \describe{
    \item{\code{Test-practice reliability}}{contains the IAT reliability.}
    \item{\code{Number of Participants}}{Contains the number of participants
      on which the reliability was computed.}
    }
}
\description{
Compute the practice -- test IAT reliability.
}
\examples{
# compute D-score 2 for the IAT data ###
  data("raw_data") # import data
  iat_cleandata <- clean_iat(raw_data, sbj_id = "Participant",
                          block_id = "blockcode",
                          mapA_practice = "practice.iat.Milkbad",
                          mapA_test = "test.iat.Milkbad",
                          mapB_practice = "practice.iat.Milkgood",
                          mapB_test = "test.iat.Milkgood",
                          latency_id = "latency",
                          accuracy_id = "correct",
                          trial_id = "trialcode",
                          trial_eliminate = c("reminder", "reminder1"),
                          demo_id = "blockcode",
                          trial_demo = "demo")
  iat_data <- iat_cleandata[[1]]
# calculate D-score
  iat_dscore <- computeD(iat_data,
                         Dscore =  "d2")
  IATrel(iat_dscore)
}
