% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomial_data_aug.R
\name{multinomial_data_aug}
\alias{multinomial_data_aug}
\title{Data Augmentation algorithm for multinomial data}
\usage{
multinomial_data_aug(x_y, z_Os_y, enum_comp, conj_prior = c("none",
  "data.dep", "flat.prior", "non.informative"), alpha = NULL, burnin = 500,
  post_draws = 1000, verbose = FALSE)
}
\arguments{
\item{x_y}{A \code{data.frame} of observed counts for complete observations.}

\item{z_Os_y}{A \code{data.frame} of observed marginal-counts for incomplete observations.}

\item{enum_comp}{A \code{data.frame} specifying a vector of all possible observed patterns.}

\item{conj_prior}{A string specifying the conjugate prior. One of 
\code{c("none", "data.dep", "flat.prior", "non.informative")}.}

\item{alpha}{The vector of counts \eqn{\alpha} for a \eqn{Dir(\alpha)} prior. Must be specified if 
\code{conj_prior} is either \code{c("data.dep", "flat.prior")}. If \code{flat.prior}, specify 
as a scalar. If \code{data.dep}, specify as a vector with key matching \code{enum_comp}.}

\item{burnin}{A scalar specifying the number of iterations to use as a burnin. Defaults 
to \code{500}.}

\item{post_draws}{An integer specifying the number of draws from the posterior distribution.
Defaults to \code{1000}.}

\item{verbose}{Logical. If \code{TRUE}, provide verbose output on each iteration.}
}
\value{
An object of class \code{\link{mod_imputeMulti-class}}.
}
\description{
Implement the Data Augmentation algorithm for multvariate multinomial data given
observed counts of complete and missing data (\eqn{Y_obs} and \eqn{Y_mis}). Allows for specification
of a Dirichlet conjugate prior.
}
\examples{
\dontrun{
 data(tract2221)
 x_y <- multinomial_stats(tract2221[,1:4], output= "x_y")
 z_Os_y <- multinomial_stats(tract2221[,1:4], output= "z_Os_y")
 x_possible <- multinomial_stats(tract2221[,1:4], output= "possible.obs")

 imputeDA_mle <- multinomial_data_aug(x_y, z_Os_y, x_possible, n_obs= nrow(tract_2221),
                     conj_prior= "none", verbose= TRUE)
}

}
\seealso{
\code{\link{multinomial_em}}, \code{\link{multinomial_impute}}
}

