% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.seadec.R
\name{na.seadec}
\alias{na.seadec}
\title{Seasonally Decomposed Missing Value Imputation}
\usage{
na.seadec(x, algorithm = "interpolation", ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{algorithm}{Algorithm to be used after decomposition. Accepts the following input:
\itemize{
   \item{"interpolation" - Imputation by Interpolation}
   \item{"locf" - Imputation by Last Observation Carried Forward}
   \item{"mean" - Imputation by Mean Value}
   \item{"random" - Imputation by Random Sample}
   \item{"kalman" - Imputation by Kalman Smoothing and State Space Models}
   \item{"ma" - Imputation by Weighted Moving Average}
   }}

\item{...}{Additional parameters for these algorithms that can be passed through. Look at \code{\link[imputeTS]{na.interpolation}}, \code{\link[imputeTS]{na.locf}},
\code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.mean}} for parameter options.}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Removes the seasonal component from the time series, performs imputation on the deseasonalized series and afterwards adds the seasonal component again.
}
\examples{
#Example 1: Perform seasonal imputation using algorithm = "interpolation"
na.seadec(tsAirgap, algorithm = "interpolation")

#Example 2: Perform seasonal imputation using algorithm = "mean"
na.seadec(tsAirgap, algorithm = "mean")

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.kalman}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seasplit}}
}

