% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compUpdate}
\alias{compUpdate}
\title{Update orientation with 3-axis acc and gyr data}
\usage{
compUpdate(acc, gyr, dt, initQuat, gain)
}
\arguments{
\item{acc}{A numeric 3-vector of 3-axis accelerometer readings in g}

\item{gyr}{A numeric 3-vector of 3-axis gyroscope readings in rad/sec}

\item{dt}{A numeric of time duration in sec}

\item{initQuat}{A numeric 4-vector of the starting orientation in quaternion}

\item{gain}{A numeric gain factor between 0 and 1}
}
\value{
A numeric 4-vector of the ending orientation in quaternion
}
\description{
\code{compUpdate()} uses complementary filtering to update the orientation, given
an initial orientation, readings of a 3-axis accelerometer and a 3-axis
gyroscope. time duration, and a gain factor
}
\examples{
compUpdate(c(0, 0, -1), c(1, 0, 0), 0.1, c(1, 0, 0, 0), 0.1)

}
