% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{checkVar}
\alias{checkVar}
\title{Check if variable(s) are present in reference: either in columns in 
a dataset or in reference set.}
\usage{
checkVar(
  var,
  varLabel,
  varUncheck = NULL,
  varRef,
  refLabel = ifelse(!missing(varRef), "reference variable", "data"),
  data,
  msgType = c("warning", "error")
)
}
\arguments{
\item{var}{String with variable to check.}

\item{varLabel}{String with label for \code{var}, e.g.
name of associated parameter.}

\item{varUncheck}{(Named) character vector with extra variables 
in \code{var} which shouldn't be checked.}

\item{varRef}{(Named) character vector with set of reference variables.}

\item{refLabel}{String with label for the reference}

\item{data}{Data.frame with data.}

\item{msgType}{String with type of message returned, either a 'warning' (default)
or an error.}
}
\value{
Depending on \code{msgType}:
\itemize{
\item{\code{warning}: }{warning is printed in the console, and a 
\code{var} filtered with element not in \code{data}
or in \code{refSet} is returned.
If filtered \code{var} is empty, NULL is returned.}
\item{\code{error}: }{an error is triggered.}
}
}
\description{
Filter variables not present in the data or in reference set with a warning,
and only returned filtered vector, or NULL if empty.
}
\author{
Laure Cougnaud
}
