% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convert_raw.R
\name{convert_raw}
\alias{convert_raw}
\title{Genotype format converter}
\usage{
convert_raw(genotypes)
}
\arguments{
\item{genotypes}{Raw genotype data frame or matrix. Rows represent individuals and each locus has two adjacent columns.
       Alleles within loci can be coded as numbers (e.g. microsatellite length) or characters (e.g. "A", "T")
       See data(mouse_msat) for an example. Missing values should be coded as NA.}
}
\value{
Data.frame object with 0 (homozygote), 1 (heterozygote) and NA (missing data).
        Each locus is a column and each individual is a row.
}
\description{
Turns raw genotype data into 0 (homozygote), 1 (heterozygote) and NA (missing), which is the working format for
the inbreedR functions.
A raw genotype matrix has individuals in rows and each locus in two adjacent columns. Individual ID's can be rownames.
Type data(mouse_msats) for an example raw genotype data frame.
}
\examples{
# Mouse microsatellite data with missing values coded as NA
data(mouse_msats)
genotypes <- convert_raw(mouse_msats)
head(genotypes)
}
\author{
Martin Stoffel (martin.adam.stoffel@gmail.com)
}

