% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Denue_Inegi.R
\name{denue_inegi}
\alias{denue_inegi}
\title{Obtiene establecimientos del DENUE}
\usage{
denue_inegi(latitud, longitud, token, metros = 250, keyword = "todos")
}
\arguments{
\item{latitud}{Vector en caracter de latitud (en decimal) de lugar}

\item{longitud}{Vector en caracter de longitud (en decimal) de lugar}

\item{token}{Token emitida por INEGI para acceder a API}

\item{metros}{Distancia en metros a la redonda para buscar establecimientos. Default = 250}

\item{keyword}{Palabra clave de establecimiento para buscar. Por default busca todos.}
}
\value{
Data.frame
}
\description{
Regresa data.frame de datos de establecimientos registrados en el DENUE en zona aledaña a las coordenadas.  
Es una de las funciones primitivas del paquete.
}
\examples{
#Traer todos los establecimientos a 1 km de la macro plaza en Monterrey
\dontrun{
token<-"webservice_token"
latitud<-"25.669194"
longitud<-"-100.30990"
Negocios <- denue_inegi(latitud, longitud, token, metros = 1000)
}

}
\author{
Eduardo Flores
}

