% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{t_test}
\alias{t_test}
\title{A tidier version of t.test for two sample tests}
\usage{
t_test(data, formula, alternative = "two_sided", ...)
}
\arguments{
\item{data}{a data frame that can be coerced into a \code{\link[tibble]{tibble}}}

\item{formula}{a formula with the response variable on the left and the explanatory on the right}

\item{alternative}{character string specifying the direction of the alternative hypothesis. Options are
"\code{two_sided}" (default), "\code{greater}", or "\code{less}".}

\item{...}{currently ignored}
}
\description{
A tidier version of t.test for two sample tests
}
\examples{
# t test for comparing mpg against automatic/manual
  mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    t_test(mpg ~ am, alternative = "less")
}
