% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify}
\alias{specify}
\title{Specify the response and explanatory variables}
\usage{
specify(x, formula, response = NULL, explanatory = NULL,
  success = NULL)
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{formula}{A formula with the response variable on the left and the
explanatory on the right.}

\item{response}{The variable name in \code{x} that will serve as the response.
This is alternative to using the \code{formula} argument.}

\item{explanatory}{The variable name in \code{x} that will serve as the
explanatory variable.}

\item{success}{The level of \code{response} that will be considered a success, as
a string. Needed for inference on one proportion, a difference in
proportions, and corresponding z stats.}
}
\value{
A tibble containing the response (and explanatory, if specified)
variable data.
}
\description{
\code{specify()} also converts character variables chosen to be \code{factor}s.
}
\examples{
# Permutation test similar to ANOVA
mtcars \%>\%
  dplyr::mutate(cyl = factor(cyl)) \%>\%
  specify(mpg ~ cyl) \%>\%
  hypothesize(null = "independence") \%>\%
  generate(reps = 100, type = "permute") \%>\%
  calculate(stat = "F")

}
