% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influxdb_main.R
\name{influx_write}
\alias{influx_write}
\title{Write an xts object to an InfluxDB server}
\usage{
influx_write(con, db, xts, measurement = NULL, rp = NULL,
  precision = c("s", "ns", "u", "ms", "m", "h"), consistency = c(NULL,
  "one", "quroum", "all", "any"), max_points = 5000, use_integers = FALSE)
}
\arguments{
\item{con}{An \code{influx_connection} object (s. \code{\link{influx_connection}}).}

\item{db}{Sets the target database for the query.}

\item{xts}{The xts object to write to an InfluxDB server.}

\item{measurement}{Sets the name of the measurement.}

\item{rp}{Sets the target retention policy for the write. If not present the
default retention policy is used.}

\item{precision}{Sets the precision of the supplied Unix time values
("s", "ns", "u", "ms", "m", "h"). If not present timestamps are assumed to be
in seconds.}

\item{consistency}{Set the number of nodes that must confirm the write.
If the requirement is not met the return value will be partial write
if some points in the batch fail, or write failure if all points in the batch
fail.}

\item{max_points}{Defines the maximum points per batch (defaults to 5000).}

\item{use_integers}{Should integers (instead of doubles) be written if present?}
}
\value{
A list of server responses.
}
\description{
This function writes an xts object to an InfluxDB server.
Columnnames of the xts object are used as InfluxDB's field keys,
xts's coredata represent field values. Attributes are preserved and written
as tag keys and values, respectively.
}
\references{
\url{https://docs.influxdata.com/influxdb/}
}
\seealso{
\code{\link[xts]{xts}}, \code{\link[influxdbr]{influx_connection}}
}
