% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_sample.R
\name{select_sample}
\alias{select_sample}
\title{Select Subset of Rows}
\usage{
select_sample(data, n = 100, seed = 1313)
}
\arguments{
\item{data}{set of observations. Profile will be calculated for every observation (every row)}

\item{n}{number of observations to select.}

\item{seed}{seed for random number generator.}
}
\value{
a data frame with selected rows
}
\description{
Function \code{\link{select_sample}} selects subset of rows from data set.
This is useful if data is large and we need just a sample to calculate profiles.
}
\details{
Note that \code{select_subsample()} function is S3 generic.
If you want to work on non standard data sources (like H2O ddf, external databases)
you should overload it.
}
\examples{
library("DALEX")

small_apartments <- select_sample(apartments_test)
head(small_apartments)

}
