% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{generate.bru}
\alias{generate.bru}
\title{Sampling based on bru posteriors}
\usage{
\method{generate}{bru}(object, data, formula = NULL, n.samples = 100, ...)
}
\arguments{
\item{object}{A \code{bru} object obtained by calling \link{bru}.}

\item{data}{A data.frame or SpatialPointsDataFrame of covariates needed for sampling.}

\item{formula}{A formula determining which effects to sample from and how to combine them analytically.}

\item{n.samples}{Integer setting the number of samples to draw in order to calculate the posterior statistics. 
The default is rather low but provides a quick approximate result.}

\item{...}{ignored arguments (needed for S3 compatibility).}
}
\value{
Predicted values
}
\description{
Takes a fitted \code{bru} object produced by the function \link{bru}() and produces samples given 
a new set of values for the model covariates or the original values used for the model fit. The
samples can be based on any R expression that is valid given these values/covariates and the joint
posterior of the estimated random effects.
 
Mean value predictions are accompanied by the standard errors, upper and lower 2.5% quantiles, the
median, variance, coefficient of variation as well as the variance and minimum and maximum sample
value drawn in course of estimating the statistics.
}
\examples{
\donttest{
# Generate data for a simple linear model

input.df <- data.frame(x=cos(1:10))
input.df <- within(input.df, y <- 5 + 2*cos(1:10) + rnorm(10, mean=0, sd=0.1))

# Fit the model

fit <- bru(y ~ xeff(map = x, model = "linear"), "gaussian", input.df)
summary(fit)

# Generate samples for some predefined x

df = data.frame(x = seq(-4, 4, by = 0.1))
smp = generate(fit, df, ~ xeff + Intercept, n.samples = 10)

# Plot the resulting realizations

plot(df$x, smp[[1]], type = "l")
for (k in 2:length(smp)) points(df$x, smp[[k]], type = "l")

# We can also draw samples form the joint posterior

df = data.frame(x = 1)
smp = generate(fit, df, ~ data.frame(xeff, Intercept), n.samples = 10)
smp[[1]]

# ... and plot them

plot(do.call(rbind, smp))
}
}
\seealso{
Other sample generators: \code{\link{generate}}
}
