% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru.options}
\alias{bru.options}
\title{Additional \link{bru} options}
\usage{
bru.options(mesh = NULL, run = TRUE, max.iter = 10, offset = 0,
  result = NULL, E = 1, Ntrials = 1,
  control.compute = inlabru:::iinla.getOption("control.compute"),
  control.inla = inlabru:::iinla.getOption("control.inla"),
  control.fixed = inlabru:::iinla.getOption("control.fixed"), ...)
}
\arguments{
\item{mesh}{An \code{inla.mesh} object for spatial models without SPDE components. Mostly used for successive spatial predictions.}

\item{run}{If TRUE, run inference. Otherwise only return configuration needed to run inference.}

\item{max.iter}{maximum number of inla iterations}

\item{offset}{the usual \link[INLA]{inla} offset. If a nonlinear formula is used, the resulting Taylor approximation constant will be added to this automatically.}

\item{result}{An \code{inla} object returned from previous calls of \link[INLA]{inla}, \link{bru} or \link{lgcp}. This will be used as a starting point for further improvement of the approximate posterior.}

\item{E}{\link[INLA]{inla} 'poisson' likelihood exposure parameter}

\item{Ntrials}{\link[INLA]{inla} 'binomial' likelihood parameter}

\item{control.compute}{INLA option, See \link[INLA]{control.compute}}

\item{control.inla}{INLA option, See \link[INLA]{control.inla}}

\item{control.fixed}{INLA option, See \link[INLA]{control.fixed}}

\item{...}{Additional options passed on to \link[INLA]{inla}}
}
\description{
Additional \link{bru} options
}
\examples{

\donttest{

# Generate default bru options
opts = bru.options()

# Print them:
opts

}

}
\author{
Fabian E. Bachl <\email{bachlfab@gmail.com}>
}
