% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{component_list}
\alias{component_list}
\alias{bru_component_list}
\alias{component_list.formula}
\alias{component_list.list}
\alias{[.component_list}
\title{Methods for inlabru component lists}
\usage{
component_list(...)

\method{component_list}{formula}(object, lhoods = NULL, envir = NULL, ...)

\method{component_list}{list}(object, lhoods = NULL, envir = NULL, ...)

\method{[}{component_list}(x, i)
}
\arguments{
\item{\dots}{Parameters passed on to other methods}

\item{object}{The object to operate on}

\item{lhoods}{A \code{bru_like_list} object}

\item{envir}{An evaluation environment to override the evaluation
environment}

\item{x}{\code{component_list} object from which to extract element(s)}

\item{i}{indices specifying elements to extract}
}
\description{
Constructor methods for inlabru component lists. Syntax details are given in
\code{\link[=component]{component()}}.
}
\details{
\itemize{
\item \code{component_list.formula}: Convert a component formula
into a \code{component_list} object
}

\itemize{
\item \code{component_list.list}: Combine a list of components and/or component formulas
into a \code{component_list} object
}
}
\examples{
# As an example, let us create a linear component. Here, the component is
# called "myLinearEffectOfX" while the covariate the component acts on is
# called "x". Note that a list of components is returned because the
# formula may define multiple components

eff <- component_list(~ myLinearEffectOfX(main = x, model = "linear"))
summary(eff[[1]])
# Equivalent shortcuts:
eff <- component_list(~ myLinearEffectOfX(x, model = "linear"))
eff <- component_list(~ myLinearEffectOfX(x))
# Individual component
eff <- component("myLinearEffectOfX", main = x, model = "linear")
}
\seealso{
Other component constructors: 
\code{\link{component}()}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com} and
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\concept{component constructors}
\concept{component contructors}
