% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_crs.R
\name{fm_identical_CRS}
\alias{fm_identical_CRS}
\title{Check if two CRS objects are identical}
\usage{
fm_identical_CRS(crs0, crs1, crsonly = FALSE)
}
\arguments{
\item{crs0, crs1}{Two \code{sf::crs}, \code{sp::CRS}, \code{fm_crs} or \code{inla.CRS} objects to be compared.}

\item{crsonly}{logical. If \code{TRUE} and any of \code{crs0} and \code{crs1} are \code{fm_crs} or \code{inla.CRS}
objects, extract and compare only the \code{sf::crs} or \code{sp::CRS} aspects. Default: \code{FALSE}}
}
\description{
Check if two CRS objects are identical
}
\examples{

crs0 <- crs1 <- fm_crs("longlat_globe")
fm_crs_oblique(crs1) <- c(0, 90)
print(c(
  fm_identical_CRS(crs0, crs0),
  fm_identical_CRS(crs0, crs1),
  fm_identical_CRS(crs0, crs1, crsonly = TRUE)
))
}
\seealso{
\code{\link[=fm_crs]{fm_crs()}}, \link[=fm_crs]{fm_CRS()}
}
\keyword{internal}
