% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cities.R
\docType{data}
\name{cities}
\alias{cities}
\title{Cities and Towns}
\format{
A \href{https://r-spatial.github.io/sf/articles/sf1.html}{simple feature} with fields:
\describe{
\item{\code{name}}{City name.}
\item{\code{id}}{Unique identifier.}
\item{\code{geometry}}{Zero-dimensional geometry containing a single point.}
}
}
\source{
Spatial point extracts were obtained from the
Master Address File / Topologically Integrated Geographic Encoding and Referencing
(\href{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html}{MAF/TIGER})
Database (MTDB), 2023 data collection, released November 22, 2023. Which is a part of the
U.S. Department of Commerce, U.S. Census Bureau, Geography Division/Cartographic Products Branch.
The centroids of these extracts were cropped to the study area, and any non-essential data was removed.
}
\usage{
cities
}
\description{
Cities and towns (populated places) in the vicinity of Idaho National Laboratory, eastern Idaho.
}
\examples{
print(cities)

plot(cities["name"], pch = 19)
}
\keyword{datasets}
