% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roads.R
\docType{data}
\name{roads}
\alias{roads}
\title{Road Network}
\format{
A \href{https://r-spatial.github.io/sf/articles/sf1.html}{simple feature} with fields:
\describe{
\item{\code{name}}{Street or road name.}
\item{\code{id}}{Unique identifier.}
\item{\code{prisec_fl}}{Whether a road is classified as primary or secondary.}
\item{\code{geometry}}{Sequence of points connected by straight, non-self-intersecting line pieces,
one-dimensional geometry.}
}
}
\source{
Spatial line extracts were obtained from the
Master Address File / Topologically Integrated Geographic Encoding and Referencing
(\href{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html}{MAF/TIGER})
Database (MTDB), 2023 data collection, released November 22, 2023. Which is a part of the
U.S. Department of Commerce, U.S. Census Bureau, Geography Division/Cartographic Products Branch.
These lines were cropped to the study area, and any non-essential data was removed.
}
\usage{
roads
}
\description{
Road network in the vicinity of Idaho National Laboratory, eastern Idaho.
}
\examples{
print(roads)
}
\keyword{datasets}
