% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMap.R
\name{PlotMap}
\alias{PlotMap}
\title{Plot Method for Maps}
\usage{
PlotMap(r, layer = 1, att = NULL, n = NULL, breaks = NULL,
  xlim = NULL, ylim = NULL, zlim = NULL, asp = NULL,
  extend.xy = FALSE, extend.z = FALSE, reg.axs = TRUE,
  dms.tick = FALSE, bg.lines = FALSE, bg.image = NULL,
  bg.image.alpha = 1, pal = NULL, col = NULL, max.dev.dim = c(43,
  56), labels = NULL, scale.loc = NULL, arrow.loc = NULL,
  explanation = NULL, credit = NULL, shade = NULL,
  contour.lines = NULL, rivers = NULL, lakes = NULL, roads = NULL,
  draw.key = NULL, draw.raster = TRUE, file = NULL,
  close.file = TRUE, useRaster, simplify)
}
\arguments{
\item{r}{'Raster*', 'Spatial*', or 'CRS'.
An object that can be converted to a raster layer, or coordinate reference system (CRS).}

\item{layer}{'integer'.
Layer to extract from if \code{r} is of class 'RasterStack/Brick' or 'SpatialGridDataFrame'.}

\item{att}{'integer' or 'character'.
The levels attribute to use in the Raster Attribute Table (RAT);
requires \code{r} values of class factor.}

\item{n}{'integer'.
Desired number of intervals to partition the range of raster values (or \code{zlim} if specified) (optional).}

\item{breaks}{'numeric'.
Vector of break points used to partition the colors representing numeric raster values (optional).}

\item{xlim}{'numeric'.
Vector of length 2 giving the minimum and maximum values for the \emph{x}-axis.}

\item{ylim}{'numeric'.
Vector of length 2 giving the minimum and maximum values for the \emph{y}-axis.}

\item{zlim}{'numeric'.
Vector of length 2 giving the minimum and maximum raster values for which colors should be plotted.}

\item{asp}{'numeric'.
\emph{y/x} aspect ratio for spatial axes.
Defaults to 1 (one unit on the \emph{x}-axis equals one unit on the \emph{y}-axis) when \code{r} is projected,
otherwise, a calculated value based on axes limits is used.}

\item{extend.xy}{'logical'.
If true, the spatial limits will be extended to the next tick mark on the axes beyond the grid extent.}

\item{extend.z}{'logical'.
If true, the raster value limits will be extended to the next tick mark on the color key beyond the measured range.
Not used if the \code{zlim} argument is specified.}

\item{reg.axs}{'logical'.
If true, the spatial data range is extended.}

\item{dms.tick}{'logical'.
If true and \code{r} is projected, the axes tickmarks are specified in degrees, minutes, and decimal seconds (DMS).}

\item{bg.lines}{'logical'.
If true, grids or graticules are drawn in back of the raster layer using white lines and a grey background.}

\item{bg.image}{'RasterLayer'.
An image to be drawn in back of the main raster layer \code{r}, image colors are derived from a vector of gray levels.
Raster values typically represent hill shading based on the slope and aspect of land-surface elevations,
see \code{\link[raster]{hillShade}} function.}

\item{bg.image.alpha}{'numeric'.
Opacity of the background image from 0 to 1.}

\item{pal}{'function'.
Color palette to be used to assign colors in the plot.}

\item{col}{'character'.
Vector of colors to be used in the plot.
This argument requires \code{breaks} specification for numeric values of \code{r} and
overrides any palette function specification.
For numeric values there should be one less color than breaks.
Factors require a color for each level.}

\item{max.dev.dim}{'numeric'.
Vector of length 2 giving the maximum width and height for the graphics device in picas, respectively.
Where 1 pica is equal to 1/6 of an inch, 4.2333 of a millimetre, or 12 points.
Suggested dimensions for single-column, double-column, and sidetitle figures are
\code{c(21, 56)}, \code{c(43, 56)}, and \code{c(56, 43)}, respectively.
This argument is only applicable when the \code{file} argument is specified.}

\item{labels}{'list'.
Describes the location and values of labels in the color key.
This list may include components \code{at} and \code{labels}.}

\item{scale.loc}{'character'.
Position of the scale bar in the main plot region;
see \code{\link{GetInsetLocation}} function for keyword descriptions.}

\item{arrow.loc}{'character'.
Position of the north arrow in the main plot region;
see \code{\link{GetInsetLocation}} function for keyword descriptions.}

\item{explanation}{'character'.
Label explaining the raster cell value.}

\item{credit}{'character'.
Label crediting the base map.}

\item{shade}{'list'.
If specified, a semi-transparent shade layer is drawn on top of the raster layer.
This layer is described using a list of arguments supplied to the
\code{\link[raster]{hillShade}} function.
Passed arguments include \code{angle} and \code{direction}.
Additional arguments also may be passed that control the vertical aspect ratio
(\code{z.factor}) and color opacity (\code{alpha}).}

\item{contour.lines}{'list'.
If specified, contour lines are drawn.
The contours are described using a list of arguments supplied to the \code{\link[raster]{contour}} function.
Passed arguments include \code{drawlables}, \code{method}, and \code{col}.}

\item{rivers}{'list'.
If specified, lines are drawn.
The lines are described using a list of arguments supplied to the plot method for
class '\code{\link[=SpatialLines-class]{SpatialLines}}'.
Passed arguments include \code{x}, \code{col}, and \code{lwd}.}

\item{lakes}{'list'.
If specified, polygons are drawn.
The polygons are described using a list of arguments supplied to the plot method for
class '\code{\link[=SpatialPolygons-class]{SpatialPolygons}}'.
Passed arguments include \code{x}, \code{col}, \code{border}, and \code{lwd}.
Bitmap images require a regular grid.}

\item{roads}{'list'.
If specified, lines are drawn.
The lines are described using a list of arguments supplied to the plot method for
class '\code{\link[=SpatialLines-class]{SpatialLines}}'.
Passed arguments include \code{x}, \code{col}, and \code{lwd}.}

\item{draw.key}{'logical'.
If true, a color key should be drawn.}

\item{draw.raster}{'logical'.
If true, the raster image is drawn.}

\item{file}{'character'.
Name of the output file.
Specifying this argument will start a graphics device driver for producing a
PDF or PNG file format---the file extension determines the format type.
The width and height of the graphics region will be automagically determined and
included with the function's returned values, see "Value" section for details;
these device dimensions can be useful when creating similar map layouts in dynamic reports.}

\item{close.file}{'logical'.
If true, the graphics device driver is shut down when the function exits.
Unused if \code{file = NULL}}

\item{useRaster}{'logical'.
If true, a bitmap raster is used to plot \code{r} instead of using individual polygons for each raster cell.
If \code{UseRaster} is not specified, raster images are used when the \code{\link{getOption}("preferRaster")} is true.
Unused if \code{simplify = TRUE}.}

\item{simplify}{'numeric'.
Specifying this argument will convert the raster \code{r} to spatial polygons prior to plotting,
see \code{\link{Grid2Polygons}} function for details.
If \code{simplify > 0} the geometry of the spatial polygons is generalized using the
Douglas-Peucker algorithm (Douglas and Peucker, 1961);
and \code{simplify} is the numerical tolerance value to be used by the algorithm.
See \code{gSimplify} function for additional information.}
}
\value{
Used for the side-effect of a new plot generated.
  Returns a 'list' object with the following graphical parameters:
  \describe{
    \item{din}{device dimensions \code{c(width, height)}, in inches.}
    \item{usr}{extremes of the coordinates of the plotting region \code{c(x1, x2, y1, y2)}.}
    \item{heights}{relative heights on the device \code{c(upper, lower)} for the map and color-key plots.}
  }
}
\description{
This function maps raster data and geographical features.
A key showing how the colors map to raster values is shown below the map.
The width and height of the graphics region will be automagically determined in some cases.
}
\examples{
r <- raster::raster(nrow = 10, ncol = 10, crs = NA)
r[] <- 1L
r[51:100] <- 2L
r[3:6, 1:5] <- 8L
r <- raster::ratify(r)
rat <- cbind(raster::levels(r)[[1]], land.cover = c("Pine", "Oak", "Meadow"))
levels(r) <- rat
PlotMap(r)

data(meuse, meuse.grid, package = "sp")
sp::coordinates(meuse.grid) <- ~x+y
sp::proj4string(meuse.grid) <- sp::CRS("+init=epsg:28992")
sp::gridded(meuse.grid) <- TRUE
meuse.grid <- raster::raster(meuse.grid, layer = "soil")
model <- gstat::gstat(id = "zinc", formula = zinc~1, locations = ~x+y, data = meuse)
r <- raster::interpolate(meuse.grid, model)
r <- raster::mask(r, meuse.grid)
Pal <- function(n) GetTolColors(n, start=0.3, end=0.9)
breaks <- seq(0, 2000, by = 200)
credit <- paste("Data collected in a flood plain of the river Meuse,",
                "near the village of Stein (Netherlands),",
                "\\nand iterpolated on a grid with 40-meter by 40-meter spacing",
                "using inverse distance weighting.")
PlotMap(r, breaks = breaks, pal = Pal, dms.tick = TRUE, bg.lines = TRUE,
        contour.lines = list(col = "#1F1F1F"), credit = credit,
        draw.key = FALSE, simplify = 0)
AddScaleBar(unit = c("KILOMETER", "MILES"), conv.fact = c(0.001, 0.000621371),
            loc = "bottomright", inset = c(0.1, 0.05))
AddGradientLegend(breaks, Pal, at = breaks,
                  title = "Topsoil zinc\\nconcentration\\n(ppm)", loc = "topleft",
                  inset = c(0.05, 0.1), strip.dim = c(2, 20))

m <- datasets::volcano
m <- m[nrow(m):1, ncol(m):1]
x <- seq(from = 2667405, length.out = ncol(m), by = 10)
y <- seq(from = 6478705, length.out = nrow(m), by = 10)
r <- raster::raster(m, xmn = min(x), xmx = max(x), ymn = min(y), ymx = max(y),
                    crs = "+init=epsg:27200")
credit <- paste("Digitized from a topographic map by Ross Ihaka",
                "on a grid with 10-meter by 10-meter spacing.")
explanation <- "Elevation on Auckland's Maunga Whau volcano, in meters."
PlotMap(r, extend.z = TRUE, pal = terrain.colors, scale.loc = "bottomright",
        arrow.loc = "topright", explanation = explanation, credit = credit,
        shade = list(alpha = 0.3), contour.lines = list(col = "#1F1F1FA6"),
        useRaster = TRUE)

out <- PlotMap(r, file = "Rplots1.pdf")
print(out)

pdf(file = "Rplots2.pdf", width = out$din[1], height = out$din[2])
PlotMap(r)
raster::contour(r, col = "white", add = TRUE)
dev.off()

file.remove(c("Rplots1.pdf", "Rplots2.pdf"))
graphics.off()

}
\references{
Douglas, D., and Peucker, T., 1961,
  Algorithms for the reduction of the number of points required to represent a digitized line or its caricature:
  The Canadian Cartographer, v. 10, no. 2, p. 112--122.
}
\seealso{
\code{\link{AddColorKey}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
