% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup_ino}
\alias{setup_ino}
\title{Setup}
\usage{
setup_ino(
  f,
  npar,
  ...,
  opt = set_optimizer_nlm(),
  mpvs = character(0),
  verbose = getOption("ino_progress"),
  skip_test = FALSE
)
}
\arguments{
\item{f}{An object of class \code{function}, the function to be optimized.}

\item{npar}{The length of the first argument of \code{f}, i.e. the argument over which
\code{f} is optimized.}

\item{...}{Additional and named arguments to be passed to \code{f} (optional).}

\item{opt}{The output of \code{\link{set_optimizer}}, which is an object of class
\code{optimizer}. Per default, \code{opt = set_optimizer_nlm()}, which
specifies the \code{\link[stats]{nlm}} optimizer. Can also be a list of
different \code{optimizer} objects, see the details.}

\item{mpvs}{A character vector of the argument names with multiple parameter values, see
the details. Per default, \code{mpvs = character(0)}.}

\item{verbose}{Set to \code{TRUE} (\code{FALSE}) to print (hide) the test results of the
setup at the console.}

\item{skip_test}{Set to \code{TRUE} to skip the specification tests.}
}
\value{
An object of class \code{ino}.
}
\description{
Use this function to specify the numerical optimization problem. The function
returns an object of class \code{ino} that contains all specifications.
}
\details{
\subsection{Specifying a function}{

One function \code{f} must be specified per \code{ino} object. The function
is optimized over its first argument, which should be a numeric vector of
length \code{npar}, followed by any other arguments specified via the
\code{...} argument.
}

\subsection{Specifying an optimizer}{

The numerical optimizer must be specified via the \code{opt} argument as the
output of \code{\link{set_optimizer}}. You can specify multiple optimizer for
comparison, see below.
}

\subsection{Specifying multiple parameter values}{

You can specify multiple values for each \code{...} parameter. Such arguments
must be in \code{list} format, where each list element must be a valid
parameter value. The names of these arguments must be added to the
\code{mpvs} input to make clear that you want to iterate over them.
}

\subsection{Specifying multiple optimizer}{

Specifying multiple optimizer is analogue to specifying multiple parameter
values: Submit a list of \code{optimizer} objects (i.e. outputs of
\code{\link{set_optimizer}}) to the \code{opt} argument.
}

\subsection{An example}{

Say that \code{f} is a likelihood function of \code{npar} parameters that has
the additional argument \code{data}. Say furthermore that you want to conduct
a simulation experiment of the initialization effect for \code{f} for two
different data sets. And last, say that you want to compare the
\code{\link[stats]{nlm}} optimizer and the \code{\link[stats]{optim}}
optimizer. Then, specify
\preformatted{
setup_ino(
  f = f,
  npar = npar,
  data = list("data1" = <data set 1>,
              "data2" = <data set 2>),
  opt = list("nlm"   = set_optimizer_nlm(),
             "optim" = set_optimizer_optim()),
  mpvs = c("data", "opt")
)
}
}
}
\examples{
setup_ino(
  f = f_ll_hmm,
  npar = 4,
  data = earthquakes,
  N = 2,
  neg = TRUE,
  opt = set_optimizer_nlm()
)

}
\seealso{
\code{\link[=set_optimizer]{set_optimizer()}} to specify an optimizer.
}
\keyword{specification}
