% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_correspAnalysis.R
\name{doCA}
\alias{doCA}
\title{Performs a correspondance analysis on the basis of the word-occurrence data.frame.}
\usage{
doCA(wordF, getPlot = TRUE, mwidth = 800, mheight = 800,
  formatType = "png", ...)
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{getPlot}{If \code{TRUE}, save the \code{\link[ca]{ca}} plot in the RESULTS
directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}

\item{...}{Additional arguments from the \code{\link[ca]{ca}} function.}
}
\value{
The results of the \code{\link[ca]{ca}} function.
}
\description{
Performs a correspondance analysis on the basis of the word-occurrence data.frame
   using \code{\link[ca]{ca}} function.
}
\examples{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"), excludeSW = FALSE)
file.remove(list.files(pattern = "loremIpsum"))
doCA(wordF = wordOccuDF)
}
