% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ALL_quickFunctions.R
\name{getwordOccuDF}
\alias{getwordOccuDF}
\title{A quick way to obtain the word-occurrence data.frame from a set of documents.}
\usage{
getwordOccuDF(mywd, language = "English", excludeSW = TRUE)
}
\arguments{
\item{mywd}{A character variable containing the working directory.}

\item{language}{The language used ("French", "English", "Spanish").}

\item{excludeSW}{A logical to exclude stop words.}
}
\value{
A single word-occurrrence data.frame.
}
\description{
A quick way to obtain the word-occurrence data.frame from a set of documents.
}
\examples{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"),
  excludeSW = FALSE)
file.remove(list.files(full.names = TRUE, 
  path = paste0(getwd(), "/RESULTS"), pattern = "loremIpsum"))
}
