% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_insee_title}
\alias{get_insee_title}
\title{Get title from INSEE series idbank}
\usage{
get_insee_title(..., lang = "en")
}
\arguments{
\item{...}{list of series key (idbank)}

\item{lang}{language of the title, by default it is Engligh, if lang is different from "en" then French will be the title's language}
}
\description{
Get title from INSEE series idbank
}
\details{
Query INSEE website to get series title from series key (idbank).
Any query to INSEE database can handle around 400 idbanks at maximum, if necessary the idbank list will then be splitted in several lists of 400 idbanks each.
Consequently, it is not advised to use it on the whole idbank dataset, the user should filter the idbank dataset first.
}
\examples{
title = get_insee_title("010537900")

}
