% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataprep_lt.R
\name{dataprep_lt}
\alias{dataprep_lt}
\title{Data preparation}
\usage{
dataprep_lt(data, ID, W, time, event, Z)
}
\arguments{
\item{data}{a data frame that includes the variables named in the \code{ID}, \code{time}, \code{event}, and \code{z} arguments}

\item{ID}{a variable indicating individuals' ID}

\item{W}{a vector of left-truncated time points}

\item{time}{a variable indicating observed time points}

\item{event}{a vector of event indicator. If an observation is righ-censored, \code{event = 0}; otherwise, \code{event = 1} or \code{event = 2}, where \code{1} represents the first cause of failure, and \code{2} represents the second cause of failure. The current version of package only allows two causes of failure.}

\item{Z}{a vector of variables indicating name of covariates}
}
\value{
a data frame
}
\description{
The function \code{dataprep_lt} reshapes data from a long format to a ready-to-use format to be used directly in the function \code{ciregic_lt}.
}
\details{
The function \code{dataprep_lt} provides a ready-to-use data format that can be directly used in the function \code{ciregic_lt}. The returned data frame consists of \code{id}, \code{v}, \code{u}, \code{c}, and covariates as columns. The \code{v} and \code{u} indicate time window with the last observation time before the event and the first observation after the event. The \code{c} represents a type of event, for example, \code{c = 1} for the first cause of failure, \code{c = 2} for the second cause of failure, and \code{c = 0} for the right-censored.  For individuals having one time record with the event, the lower bound \code{v} will be replaced by zero, for example \code{(0, v]}. For individuals having one time record without the event, the upper bound \code{u} will be replaced by \code{Inf}, for example \code{(v, Inf]}.
}
\author{
Jun Park, \email{jp84 at iu dot edu}

Giorgos Bakoyannis, \email{gbakogia at iu dot edu}
}
\keyword{dataprep_lt}
