% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dataframe.R
\name{if_col_present}
\alias{if_col_present}
\title{Execute a function or return a value if a column in present in a dataframe}
\usage{
if_col_present(df, col, if_present, if_missing = ~.x)
}
\arguments{
\item{df}{a dataframe}

\item{col}{a column name}

\item{if_present}{a \code{purrr} style function to execute on the dataframe if the
column is present (or a plain value)}

\item{if_missing}{a \code{purrr} style function to execute on the dataframe if the
column is missing (or a plain value)}
}
\value{
either the value of \code{if_present}/\code{if_absent} or the result of calling
\code{if_present}/\code{if_absent} as functions on \code{df}.
}
\description{
The simple use case. For more complex behaviour see \code{switch_pipeline()}.
}
\examples{
iris \%>\% if_col_present(Species, ~ .x \%>\% dplyr::rename(new = Species)) \%>\%
  colnames()

# in contrast to `purrr` absolute values are not interpreted as function names  
iris \%>\% if_col_present(Species2, "Yes", "No")

}
