% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{iprBarycentricRational}
\alias{iprBarycentricRational}
\title{Barycentric rational interpolator}
\usage{
iprBarycentricRational(x, y, ao = 3)
}
\arguments{
\item{x, y}{numeric vectors giving the coordinates of the known points,
without missing value}

\item{ao}{approximation order, an integer greater than or equal to 3}
}
\value{
An interpolator, for usage in \code{\link{evalInterpolator}}.
}
\description{
Barycentric rational interpolator.
}
\details{
See \href{https://www.boost.org/doc/libs/1_83_0/libs/math/doc/html/math_toolkit/barycentric.html}{Barycentric rational interpolation}.
}
\examples{
library(interpolators)
x <- c(1, 2, 4, 5)
y <- x^2
ipr <- iprBarycentricRational(x, y)
evalInterpolator(ipr, c(2, 3))
evalInterpolator(ipr, c(2, 3), derivative = 1)
}
