% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_raw.R
\name{plot_raw}
\alias{plot_raw}
\title{Plot raw data}
\usage{
plot_raw(
  data,
  type = "boxplot",
  x,
  y,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  ylimits = NULL,
  xlimits = NULL,
  xrotation = NULL,
  legend = "top",
  xtext = NULL,
  gtext = NULL,
  color = TRUE,
  linetype = 1,
  opt = NULL
)
}
\arguments{
\item{data}{raw data}

\item{type}{Type of graphic. "boxplot" or "scatterplot"}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{group}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{Limits and break of the y axis c(initial, end, brakes)}

\item{xlimits}{For scatter plot. Limits and break of the x axis c(initial,
end, brakes)}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{xtext}{Text labels in x axis using a vector}

\item{gtext}{Text labels in groups using a vector}

\item{color}{Colored figure (TRUE), black & white (FALSE) or color vector}

\item{linetype}{Line type for regression. Default = 0}

\item{opt}{Add new layers to the plot}
}
\value{
plot
}
\description{
Function use the raw data for made a boxplot graphic
}
\details{
You could add additional layer to the plot using "+" with ggplot2 options
}
\examples{

\dontrun{

library(inti)

fb <- potato

fb \%>\%
  plot_raw(type = "box"
           , x = "geno"
           , y = "twue"
           #, group = "treat"
           , color = "yes"
           ) 
           
}

}
