\name{AdmixDataSim1}
\docType{data}
\alias{AdmixDataSim1}
\title{Admixed Population Genotype Data from Simulation 1}
\description{
This data set contains genotypes for a simulated admixed
population. The simulated admixed population conisted of 500 diploid
hermaphroditic individuals with ten pairs of chromosomes, each one
Morgan in length. The admixed population resulted from an intitial
hybridization event between two parental populations (combined in equal
proportions) and mating within the admixed population continued for five
additional generations. Fitness of hybrids was determined based on a
marker at the center of chromosome 1; individuals homozygous at this
location had a fitness of 1, while heterozygotes had of fitness of
0.1. Two hundred admixed individuals were sampled at the completion of
the simulation and scored for 110 co-dominant markers spaced evenly
across all 10 linkage groups (at 10 cM intervals).

The data are provided as a matrix with rows and columns corresponding to
markers and individuals, respectively. Alleles inherited from parental
population 1 are recorded as \emph{P1} and alleles inherited from
parental population 2 are recoreded as \emph{P2}.

}
\usage{data(AdmixDataSim1)}
\format{A matrix with 110 rows and 200 columns.}
\source{From simulations conducted by CAB and ZG.}
\references{
Gompert Z. and Buerkle C. A. (2009) A powerful regression-based
method for admixture mapping of isolation across the genome of
hybrids. \emph{Molecular Ecology}, \emph{in press}.

Gompert Z. and Buerkle C. A. (2009) \emph{introgress}: a software
package for mapping components of isolation in hybrids. \emph{Molecular
  Ecology Resources}, \emph{in preparation}.  
} 

\seealso{
\code{\link{LociDataSim1}}
}

\keyword{datasets}

