% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_predict.R
\name{predict.pk}
\alias{predict.pk}
\title{Get predictions}
\usage{
\method{predict}{pk}(
  object,
  newdata = NULL,
  model = NULL,
  method = NULL,
  type = "conc",
  exclude = TRUE,
  use_scale_conc = FALSE,
  suppress.messages = NULL,
  include_NAs = FALSE,
  ...
)
}
\arguments{
\item{object}{A [pk] object.}

\item{newdata}{Optional: A `data.frame` with new data for which to make
predictions. If NULL (the default), then predictions will be made for the
data in `object$data`. `newdata` is required to contain at least the following
variables: `Time`, `Time.Units`, `Dose`, `Route`, and `Media`.}

\item{model}{Optional: Specify one or more of the fitted models for which to
make predictions. If NULL (the default), predictions will be returned for
all of the models in `object$stat_model`.}

\item{method}{Optional: Specify one or more of the [optimx::optimx()] methods
for which to make predictions. If NULL (the default), predictions will be
returned for all of the models in `object$settings_optimx$method`.}

\item{type}{Either `"conc"` (the default) or `"auc"`. `type = "conc"`
predicts concentrations; `type = "auc"` predicts area under the
concentration-time curve (AUC).}

\item{exclude}{Logical: `TRUE` to return `NA_real_` for any observations in
the data marked for exclusion (if there is a variable `exclude` in the
data, an observation is marked for exclusion when `exclude %in% TRUE`).
`FALSE` to return the prediction for each observation, regardless of
exclusion. Default `TRUE`.}

\item{use_scale_conc}{Possible values: `TRUE`, `FALSE`, or a named list with
elements `dose_norm` and `log10_trans` which themselves should be either
`TRUE` or `FALSE`. If `use_scale_conc = TRUE`, then the concentration
scaling/transformations in `object` will be applied to both predicted and
observed concentrations before the log-likelihood is computed. If
`use_scale_conc = FALSE` (the default for this function), then no
concentration scaling or transformation will be applied before the
log-likelihood is computed. If `use_scale_conc = list(dose_norm = ...,
log10_trans = ...)`, then the specified dose normalization and/or
log10-transformation will be applied.}

\item{suppress.messages}{Logical: whether to suppress message printing. If
NULL (default), uses the setting in
`object$settings_preprocess$suppress.messages`}

\item{include_NAs}{Logical: `FALSE` by default. Determines whether to include
aborted fits which have NAs as coefficients.}

\item{...}{Additional arguments.}
}
\value{
A data.frame with one row for each `data_group`, `model` and `method`.
  Includes variable `Conc_est` that contains the predicted concentration or AUC at that timepoint
  given the TK parameters for that `model` and `method` specified in [coefs()].
  If `use_scale_conc %in% FALSE`, these predictions are
  un-transformed concentrations in the same units as `object$data$Conc.Units`.
  If `use_scale_conc %in% TRUE`, the predictions are transformed
  concentrations in the same units as `object$data$Conc_trans.Units`.
}
\description{
Extract predictions from a fitted `pk` object.
}
\seealso{
Other methods for fitted pk objects: 
\code{\link{AAFE.pk}()},
\code{\link{AFE.pk}()},
\code{\link{AIC.pk}()},
\code{\link{BIC.pk}()},
\code{\link{coef.pk}()},
\code{\link{coef_sd.pk}()},
\code{\link{eval_tkstats.pk}()},
\code{\link{get_fit.pk}()},
\code{\link{get_hessian.pk}()},
\code{\link{get_tkstats.pk}()},
\code{\link{logLik.pk}()},
\code{\link{residuals.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
\concept{methods for fitted pk objects}
