% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_indicator_create.R
\name{input_indicator_create}
\alias{input_indicator_create}
\title{Create input indicator(s)}
\usage{
input_indicator_create(input_matrix, output_vector, digits = NULL)
}
\arguments{
\item{input_matrix}{A named (primary) input(s) vector or matrix created by \code{\link{primary_input_get}}}

\item{output_vector}{A named output vector created by \code{\link{output_get}}.}

\item{digits}{Rounding digits, if omitted, no rounding takes place.}
}
\description{
The function creates the input indicators from the inputs and the outputs.
}
\examples{
 
de_output <- output_get ( source = "germany_1990", geo = "DE",
                         year = 1990, unit = "MIO_EUR", 
                         households = FALSE, labelling = "iotables")

de_emp <- primary_input_get ( input = "compensation_employees",
                             source = "germany_1990", geo = "DE",
                             year = 1990, unit = "MIO_EUR", 
                             households = FALSE, labelling = "iotables")

de_emp_indicator <- input_indicator_create ( de_emp, de_output )
}
