% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward_linkages.R
\name{forward_linkages}
\alias{forward_linkages}
\title{Forward linkages}
\usage{
forward_linkages(output_coefficient_matrix, digits = NULL)
}
\arguments{
\item{output_coefficient_matrix}{An output coefficient matrix created with the 
\code{\link{output_coefficient_matrix_create}} function.}

\item{digits}{Number of decimals for rounding, defaults to \code{NULL}.}
}
\description{
Forward linkages as defined by the Eurostat Manual of Supply, Use and
Input-Output Tables (see p506-507.)
}
\examples{
#You need a table that has a total column and either the total 
#intermediate use or final use
#This is usually the case with Eurostat tables, but with the Germany data
#file total must be added.

io_table <- iotable_get () 
io_table <- io_table [1:which(tolower(io_table[,1]) =="total" ), ]
output_bp <- dplyr::select ( io_table, output_bp )
io_table <- io_table [, 1:7] 
io_table$total <- rowSums(io_table[, 2:7])
io_table <- cbind (io_table, output_bp)

de_out_coeff <- output_coefficient_matrix_create ( io_table = io_table, 
                                    type = 'final_demand',
                                    digits = 4)

forward_linkages ( output_coefficient_matrix = de_out_coeff, 
                   digits = 4 )

}
