% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_to_limesurvey.R
\name{connect_to_limesurvey}
\alias{connect_to_limesurvey}
\title{connect_to_limesurvey}
\usage{
connect_to_limesurvey(
  api_url,
  limesurvey_username,
  limesurvey_password,
  mysql_host,
  mysql_port,
  mysql_dbname,
  mysql_username,
  mysql_password
)
}
\arguments{
\item{api_url}{URL to the `LimeSurvey` RPC, e.g.
'http://localhost/index.php/admin/remotecontrol'}

\item{limesurvey_username}{Username for the `LimeSurvey` API}

\item{limesurvey_password}{Password for the `LimeSurvey` API}

\item{mysql_host}{Hostname of the MySQL server used by `LimeSurvey`}

\item{mysql_port}{Port on which the MySQL server listens for connections}

\item{mysql_dbname}{Name of the database on the MySQL server which is used by
`LimeSurvey`}

\item{mysql_username}{Username for the MySQL server}

\item{mysql_password}{Password for the MySQL server}
}
\value{
No return value, called for side effects
}
\description{
Connect to `LimeSurvey` instance via the RPC and a direct MySQL
connection.
Store the RPC session key in `options('limesurvey_session_key')`.
Store the MySQL connection object in
`options('limesurvey_mysql_connection')`.
Store the RPC URL in `options('limesurvey_api_url')`.
}
\examples{
# This example assumes a locally hosted `LimeSurvey` instance using a locally
# hosted MySQL server
\dontrun{
connect_to_limesurvey(
  api_url = 'https://localhost/index.php/admin/remotecontrol',
  limesurvey_username = 'admin',
  limesurvey_password = '1234admin',
  mysql_host = '127.0.0.1',
  mysql_port = 3306,
  mysql_dbname = 'limesurvey',
  mysql_username = 'lime',
  mysql_password = '1234lime'
)
}

}
