% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipf.R
\name{ipf}
\alias{ipf}
\title{Re-weight a Seed Table to Marginal Controls}
\usage{
ipf(seed, targets, relative_gap = 0.01, absolute_gap = 1,
  max_iterations = 50, min_weight = 0.0001, verbose = FALSE)
}
\arguments{
\item{seed}{A \code{data frame} including a \code{weight} field and necessary
columns for matching to marginal targets.}

\item{targets}{A \code{named list} of data frames.  Each name in the list 
defines a marginal dimension and must match a column from the seed table. 
The data frame associated with each name must start with an identical 
column named \code{cluster}. Each row in the target table defines a new 
cluster (these could be TAZs, tracts, districts, etc.), and every target 
table must have the same number of rows/clusters. The other column names
define the marginal categories that targets are provided for.}

\item{relative_gap}{target for convergence.  Maximum percent change to allow
any seed weight to move by while considering the process converged.  By 
default, if no weights change by more than 1%, the process has converged.
The process is said to be converged if either \code{relative_gap} or 
\code{absolute_gap} parameters have been met.}

\item{absolute_gap}{target for convergence.  Maximum absolute change to allow
any seed weight to move by while considering the process converged.  By 
default, if no weights change by more than 10, the process has converged.
The process is said to be converged if either \code{relative_gap} or 
\code{absolute_gap} parameters have been met.}

\item{max_iterations}{maximum number of iterations to perform, even if 
convergence is not reached.}

\item{min_weight}{Minimum weight to allow in any cell to prevent zero weights.
Set to .0001 by default.  Should be arbitrarily small compared to your 
seed table weights.}

\item{verbose}{Print details on the maximum expansion factor with each 
iteration? Default \code{FALSE}.}
}
\value{
the seed \code{data frame} with a column of weights appended for each
   row in the target \code{data.frames}
}
\description{
Re-weight a Seed Table to Marginal Controls
}
\keyword{internal}
