% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfRMID}
\alias{ipfRMID}
\title{Estimates the inherent difficulty of the radio map}
\usage{
ipfRMID(fingerprints, positions, rangeRSSI = c(-100, 0), noRSSI = NA,
  gridSize = 5)
}
\arguments{
\item{fingerprints}{a matrix or a data frame containing the RSSI data (fingerprints) of the
observations}

\item{positions}{a matrix or a data frame containing the positions of the fingerprints}

\item{rangeRSSI}{range of the RSSI data}

\item{noRSSI}{value used to represent a not detected AP}

\item{gridSize}{size of the grid to consider}
}
\value{
a numeric value representing the RMID value (Radio Map Inherent Difficulty)
}
\description{
Estimates the inherent difficulty of the radio map
}
\examples{
\dontrun{
    rmid <- ipfRMID(ipftrain[, 1:168], ipftrain[, 169:170], noRSSI = NA)
}
}
