/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Vector;
import org.rosuda.util.Global;

public class GlobalConfig {
    String configFile = "plugins.cfg";
    Vector par = new Vector();
    Vector val = new Vector();
    Vector pst = new Vector();
    Integer pst_level = null;
    static GlobalConfig current;

    public static GlobalConfig getGlobalConfig() {
        if (current == null) {
            current = new GlobalConfig();
        }
        return current;
    }

    public GlobalConfig() {
        if (File.separatorChar == '/') {
            this.loadSettings("/etc/plugins.cfg");
        }
        this.pst_level = new Integer(1);
        String string = System.getProperty("user.home");
        if (string == null && System.getProperty("os.name").indexOf("indows") > 0) {
            string = "C:\\";
        }
        this.configFile = string + File.separator + ".plugins.cfg";
        this.loadSettings();
        this.setParS("GlobalConfig.userConfigFile", this.configFile);
    }

    public String getParS(String string) {
        int n = this.par.indexOf(string);
        return n < 0 ? null : (String)this.val.elementAt(n);
    }

    public static String getS(String string) {
        return GlobalConfig.getGlobalConfig().getParS(string);
    }

    public Object[] getAllParameters() {
        return this.par.toArray();
    }

    public boolean setParS(String string, String string2) {
        boolean bl = this.internal_setParS(string, string2);
        if (bl) {
            this.saveSettings();
        }
        return bl;
    }

    boolean internal_setParS(String string, String string2) {
        int n = this.par.indexOf(string);
        if (n < 0) {
            this.par.addElement(string);
            this.val.addElement(string2);
            this.pst.addElement(this.pst_level);
        } else {
            this.val.setElementAt(string2, n);
            this.pst.setElementAt(this.pst_level, n);
        }
        return true;
    }

    public boolean saveSettings() {
        if (Global.DEBUG > 0) {
            System.out.println("Save to config file \"" + this.configFile + "\" ...");
        }
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(this.configFile));
            printStream.println("<globalSettings ver=100>");
            for (int i = 0; i < this.par.size(); ++i) {
                if (this.pst.elementAt(i) == null) continue;
                printStream.println("<setting name=" + this.par.elementAt(i) + ">");
                printStream.println(this.val.elementAt(i));
                printStream.println("</setting>");
                if (Global.DEBUG <= 0) continue;
                System.out.println("saveSettings.save: " + this.par.elementAt(i) + " -> " + this.val.elementAt(i));
            }
            printStream.println("</globalSettings>");
            printStream.close();
            return true;
        }
        catch (Exception exception) {
            if (Global.DEBUG > 0) {
                System.out.println("GlobalConfig.saveSettings ERR: " + exception.getMessage());
                exception.printStackTrace();
            }
            return false;
        }
    }

    public boolean loadSettings() {
        return this.loadSettings(this.configFile);
    }

    public boolean loadSettings(String string) {
        if (string == null) {
            string = this.configFile;
        }
        if (Global.DEBUG > 0) {
            System.out.println("Processing config file \"" + string + "\" ...");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            while (bufferedReader.ready()) {
                String string4 = bufferedReader.readLine();
                int n = string4.indexOf("</setting>");
                int n2 = string4.indexOf("<setting name=");
                if (Global.DEBUG > 0) {
                    System.out.println("LoadSetting: cf=" + n + ", of=" + n2 + ", isVal=" + bl + ", curPar=" + string2 + ", ln=" + string4);
                }
                if (bl) {
                    if (n >= 0) {
                        if (string3 != null) {
                            this.internal_setParS(string2, string3);
                        }
                        string3 = null;
                        bl = false;
                    } else {
                        string3 = string3 == null ? string4 : string3 + "\n" + string4;
                    }
                }
                if (n2 < 0) continue;
                int n3 = (string4 = string4.substring(n2 + 14)).indexOf(">");
                if (n3 >= 0) {
                    string4 = string4.substring(0, n3);
                }
                string2 = string4;
                bl = true;
            }
            bufferedReader.close();
            return true;
        }
        catch (Exception exception) {
            if (Global.DEBUG > 0) {
                System.out.println("GlobalConfig.loadSettings(\"" + string + "\") ERR: " + exception.getMessage());
                exception.printStackTrace();
            }
            return false;
        }
    }
}

