/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.iplots;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.MapSegment;
import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarDouble;
import org.rosuda.ibase.SVarFact;
import org.rosuda.ibase.SVarInt;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.ibase.plots.BarCanvas;
import org.rosuda.ibase.plots.HamCanvas;
import org.rosuda.ibase.plots.HistCanvas;
import org.rosuda.ibase.plots.LineCanvas;
import org.rosuda.ibase.plots.MapCanvas;
import org.rosuda.ibase.plots.MosaicCanvas;
import org.rosuda.ibase.plots.ParallelAxesCanvas;
import org.rosuda.ibase.plots.ScatterCanvas;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.FrameDevice;
import org.rosuda.ibase.toolkit.TFrame;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.util.Global;
import org.rosuda.util.MsgDialog;
import org.rosuda.util.Platform;

public class Framework
implements Dependent,
ActionListener {
    List dataset;
    SVarSet cvs;
    int tvctr;
    int dtctr;
    static boolean noInteraction = false;
    public int graphicsEngine = 0;
    private BaseCanvas[] plots;
    private boolean notificationArrived = false;
    private NotifyMsg lastNotificationMessage;

    public Framework() {
        Global.AppType = 48;
        Common.supportsBREAK = true;
        Common.appName = "iplots";
        SVar.int_NA = Integer.MIN_VALUE;
        SVar.double_NA = Double.longBitsToDouble(9218868437227407266L);
        Global.useAquaBg = false;
        Common.backgroundColor = Common.aquaBgColor;
        Platform.initPlatform("org.rosuda.iplots.");
        if (Common.breakDispatcher == null) {
            Common.breakDispatcher = new Notifier();
        }
        Common.breakDispatcher.addDepend(this);
        this.cvs = new SVarSet();
        this.cvs.setName("default");
        this.dataset = new ArrayList();
        this.dataset.add(this.cvs);
    }

    public String getNewTmpVar(String string) {
        int n = this.cvs.indexOf(string);
        if (n == -1) {
            return string;
        }
        ++this.tvctr;
        n = this.cvs.indexOf(string + "." + this.tvctr);
        if (n == -1) {
            return string + "." + this.tvctr;
        }
        return "temp." + this.tvctr;
    }

    public String getNewTmpVar() {
        ++this.tvctr;
        return "temp." + this.tvctr;
    }

    public SVarSet getCurrentSet() {
        return this.cvs;
    }

    public boolean isSetCurrent(SVarSet sVarSet) {
        return sVarSet == null && this.cvs == null || this.cvs != null && this.cvs.equals(sVarSet);
    }

    public SVarSet selectSet(String string) {
        for (int i = 0; i < this.dataset.size(); ++i) {
            SVarSet sVarSet = (SVarSet)this.dataset.get(i);
            if (!sVarSet.getName().equals(string)) continue;
            this.cvs = sVarSet;
            return sVarSet;
        }
        return null;
    }

    public SVarSet selectSet(int n) {
        return n < 0 || n >= this.dataset.size() ? null : (this.cvs = (SVarSet)this.dataset.get(n));
    }

    public SVarSet getSet(int n) {
        return n < 0 || n >= this.dataset.size() ? null : (SVarSet)this.dataset.get(n);
    }

    public int indexOfSet(SVarSet sVarSet) {
        for (int i = 0; i < this.dataset.size(); ++i) {
            SVarSet sVarSet2 = (SVarSet)this.dataset.get(i);
            if (sVarSet2 == null || !sVarSet2.equals(sVarSet)) continue;
            return i;
        }
        return -1;
    }

    public int getSetIdByName(String string) {
        for (int i = 0; i < this.dataset.size(); ++i) {
            SVarSet sVarSet = (SVarSet)this.dataset.get(i);
            if (!sVarSet.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int countSets() {
        return this.dataset.size();
    }

    public int curSetId() {
        return this.dataset.indexOf(this.cvs);
    }

    public String getSetName(int n) {
        try {
            SVarSet sVarSet = (SVarSet)this.dataset.get(n);
            return sVarSet.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSetName() {
        return this.cvs.getName();
    }

    public boolean removeSetById(int n) {
        try {
            this.dataset.remove(n);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean removeSet(SVarSet sVarSet) {
        return this.dataset.remove(sVarSet);
    }

    public void setNoInteractionFlag(boolean bl) {
        noInteraction = bl;
    }

    public boolean getNoInteractionFlag() {
        return noInteraction;
    }

    public int newSet(String string) {
        this.cvs = new SVarSet();
        if (string == null) {
            ++this.dtctr;
            string = "data." + this.dtctr;
        }
        this.cvs.setName(string);
        this.dataset.add(this.cvs);
        return this.dataset.indexOf(this.cvs);
    }

    public int getLength() {
        return this.cvs == null || this.cvs.at(0) == null ? 0 : this.cvs.at(0).size();
    }

    public int addVar(SVar sVar) {
        SMarker sMarker;
        if (this.cvs.getMarker() == null) {
            sMarker = new SMarker(sVar.size());
            this.cvs.setMarker(sMarker);
            sMarker.addDepend(this);
        }
        sMarker = this.cvs.getMarker();
        if (sVar.size() > sMarker.size()) {
            sMarker.resize(sVar.size());
        }
        return this.cvs.add(sVar);
    }

    int mmDlg(String string, int n) {
        if (noInteraction) {
            return -3;
        }
        Frame frame = new Frame("dummy");
        frame.toFront();
        MsgDialog msgDialog = new MsgDialog(frame, "Data length mismatch", "Variable \"" + string + "\" consists of " + n + " cases, but your current iSet has " + this.cvs.at(0).size() + " cases.\nDo you want to create a new iSet?", MsgDialog.yesNoCancel);
        int n2 = 0;
        if ("Cancel".equals(msgDialog.lastResult)) {
            n2 = -2;
        }
        if ("Yes".equals(msgDialog.lastResult)) {
            n2 = -3;
        }
        msgDialog.dispose();
        frame.dispose();
        return n2;
    }

    public static String msgDlg(String string, String string2, String[] stringArray) {
        if (noInteraction) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].equals("OK") && !stringArray[i].equals("Yes")) continue;
                return stringArray[i];
            }
            return stringArray.length > 0 ? stringArray[0] : "OK";
        }
        Frame frame = new Frame("dummy");
        MsgDialog msgDialog = new MsgDialog(frame, string, string2, stringArray);
        String string3 = msgDialog.lastResult;
        msgDialog.dispose();
        frame.dispose();
        return string3;
    }

    public int getCurVarSetLength() {
        return this.cvs.count() > 0 && this.cvs.at(0) != null ? this.cvs.at(0).size() : -1;
    }

    public int newVar(String string, double[] dArray) {
        if (dArray == null) {
            return -1;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: double[" + dArray.length + "]");
        }
        if (this.cvs.count() > 0 && this.cvs.at(0).size() != dArray.length) {
            if (noInteraction) {
                return -3;
            }
            int n = this.mmDlg(string, dArray.length);
            if (n < 0) {
                return n;
            }
            string = this.getNewTmpVar(string);
        } else {
            SVar sVar = this.cvs.byName(string);
            if (sVar != null) {
                if (sVar instanceof SVarDouble && ((SVarDouble)sVar).hasEqualContents(dArray)) {
                    return this.cvs.indexOf(string);
                }
                string = this.getNewTmpVar(string);
            }
        }
        SVarDouble sVarDouble = new SVarDouble(string, dArray);
        return this.addVar(sVarDouble);
    }

    boolean mapsHaveEqualContents(SVar sVar, double[] dArray, double[] dArray2) {
        return false;
    }

    void loadMapSegments(SVar sVar, double[] dArray, double[] dArray2) {
        MapSegment mapSegment;
        int n;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            if (!Double.isNaN(dArray[n])) continue;
            if (n - n2 - 1 > 0) {
                mapSegment = new MapSegment();
                mapSegment.add(dArray, dArray2, n2, n - n2 - 1, false);
                sVar.add(mapSegment);
            } else {
                sVar.add(null);
            }
            n2 = n + 1;
        }
        if (n2 < n) {
            mapSegment = new MapSegment();
            mapSegment.add(dArray, dArray2, n2, n - n2 - 1, false);
            sVar.add(mapSegment);
        }
    }

    public int newVar(String string, double[] dArray, double[] dArray2) {
        SVar sVar;
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            return -1;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: polygons[" + dArray.length + "]");
        }
        if ((sVar = this.cvs.byName(string)) != null) {
            if (sVar.getContentsType() == 8 && this.mapsHaveEqualContents(sVar, dArray, dArray2)) {
                return this.cvs.indexOf(string);
            }
            string = this.getNewTmpVar(string);
        }
        sVar = new SVarObj(string, false, false);
        sVar.setContentsType(8);
        this.loadMapSegments(sVar, dArray, dArray2);
        return this.addVar(sVar);
    }

    public int newVar(String string, int[] nArray) {
        if (nArray == null) {
            return -1;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + nArray.length + "]");
        }
        if (this.cvs.count() > 0 && this.cvs.at(0).size() != nArray.length) {
            if (noInteraction) {
                return -3;
            }
            int n = this.mmDlg(string, nArray.length);
            if (n < 0) {
                return n;
            }
            string = this.getNewTmpVar(string);
        } else {
            SVar sVar = this.cvs.byName(string);
            if (sVar != null) {
                if (sVar instanceof SVarInt && ((SVarInt)sVar).hasEqualContents(nArray)) {
                    return this.cvs.indexOf(string);
                }
                string = this.getNewTmpVar(string);
            }
        }
        SVarInt sVarInt = new SVarInt(string, nArray);
        return this.addVar(sVarInt);
    }

    public int newVar(String string, String[] stringArray) {
        if (stringArray == null) {
            return -1;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: String[]");
        }
        if (this.cvs.count() > 0 && this.cvs.at(0).size() != stringArray.length) {
            if (noInteraction) {
                return -3;
            }
            int n = this.mmDlg(string, stringArray.length);
            if (n < 0) {
                return n;
            }
        }
        SVarObj sVarObj = new SVarObj(string);
        int n = 0;
        while (n < stringArray.length) {
            ((SVar)sVarObj).add(stringArray[n++]);
        }
        return this.addVar(sVarObj);
    }

    public int newVar(String string, int[] nArray, String[] stringArray) {
        if (nArray == null) {
            return -1;
        }
        if (stringArray == null) {
            return this.newVar(string, nArray);
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + nArray.length + "] + levels[" + stringArray.length + "]");
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        if (this.cvs.count() > 0 && this.cvs.at(0).size() != nArray.length) {
            if (noInteraction) {
                return -3;
            }
            int n3 = this.mmDlg(string, nArray.length);
            if (n3 < 0) {
                return n3;
            }
            string = this.getNewTmpVar(string);
        } else {
            SVar sVar = this.cvs.byName(string);
            if (sVar != null) {
                if (sVar instanceof SVarFact && ((SVarFact)sVar).hasEqualContents(nArray, stringArray)) {
                    return this.cvs.indexOf(string);
                }
                string = this.getNewTmpVar(string);
            }
        }
        SVarFact sVarFact = new SVarFact(string, nArray, stringArray);
        return this.addVar(sVarFact);
    }

    public int newVar(String string, int[] nArray, String string2) {
        return this.newVar(string, nArray, new String[]{string2});
    }

    public static String[] toStringArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public int replaceVar(int n, double[] dArray) {
        SVar sVar = this.cvs.at(n);
        if (sVar == null) {
            return -1;
        }
        if (!(sVar instanceof SVarDouble)) {
            return -1;
        }
        ((SVarDouble)sVar).replaceAll(dArray);
        return n;
    }

    public int replaceVar(int n, int[] nArray) {
        SVar sVar = this.cvs.at(n);
        if (sVar == null) {
            return -1;
        }
        if (sVar instanceof SVarInt) {
            ((SVarInt)sVar).replaceAll(nArray);
        } else if (sVar instanceof SVarDouble) {
            ((SVarDouble)sVar).replaceAll(nArray);
        } else {
            return -1;
        }
        return n;
    }

    public int replaceVar(int n, int[] nArray, String[] stringArray) {
        SVar sVar = this.cvs.at(n);
        if (sVar == null) {
            return -1;
        }
        if (!(sVar instanceof SVarFact)) {
            return -1;
        }
        ((SVarFact)sVar).replaceAll(nArray, stringArray);
        return n;
    }

    public void update() {
        SMarker sMarker = this.cvs.getMarker();
        if (sMarker != null) {
            sMarker.NotifyAll(new NotifyMsg(sMarker, 12289));
        }
    }

    public SVar getVar(int n) {
        return this.cvs.at(n);
    }

    public SVar getVar(String string) {
        return this.cvs.byName(string);
    }

    public void updateMarker(SVarSet sVarSet, int n) {
        if (sVarSet.getMarker() == null) {
            SMarker sMarker = new SMarker(sVarSet.at(n).size());
            sVarSet.setMarker(sMarker);
            sMarker.addDepend(this);
        }
    }

    public FrameDevice newFrame() {
        return this.newFrame("<unnamed>", true, 0);
    }

    public FrameDevice newFrame(String string) {
        return this.newFrame(string, true, 144);
    }

    public FrameDevice newFrame(String string, int n) {
        return this.newFrame(string, true, n);
    }

    public FrameDevice newFrame(String string, boolean bl, int n) {
        if (this.graphicsEngine == 0) {
            return new TFrame(string, bl, n);
        }
        if (this.graphicsEngine == 1) {
            return new TJFrame(string, bl, n);
        }
        if (this.graphicsEngine == 2) {
            return new TFrame(string, bl, n);
        }
        return new TFrame(string, bl, n);
    }

    public void setGraphicsEngine(int n) {
        this.graphicsEngine = n;
    }

    public int getGraphicsEngine() {
        return this.graphicsEngine;
    }

    public void addNewPlot(BaseCanvas baseCanvas) {
        if (this.plots == null) {
            this.plots = new BaseCanvas[1];
        } else {
            BaseCanvas[] baseCanvasArray = this.plots;
            this.plots = new BaseCanvas[baseCanvasArray.length + 1];
            System.arraycopy(baseCanvasArray, 0, this.plots, 0, baseCanvasArray.length);
            baseCanvasArray = null;
        }
        this.plots[this.plots.length - 1] = baseCanvas;
    }

    public ScatterCanvas newScatterplot(int n, int n2) {
        return this.newScatterplot(this.cvs, n, n2);
    }

    public ScatterCanvas newScatterplot(SVarSet sVarSet, int n, int n2) {
        this.updateMarker(sVarSet, n);
        String string = "Scatterplot (" + sVarSet.at(n2).getName() + " vs " + sVarSet.at(n).getName() + ")";
        FrameDevice frameDevice = this.newFrame(string, 137);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        ScatterCanvas scatterCanvas = new ScatterCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarSet.at(n), sVarSet.at(n2), sVarSet.getMarker());
        frameDevice.add(scatterCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(scatterCanvas);
        }
        scatterCanvas.setSize(new Dimension(400, 300));
        scatterCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(scatterCanvas.getWidth(), scatterCanvas.getHeight()));
        frameDevice.pack();
        scatterCanvas.repaint();
        this.addNewPlot(scatterCanvas);
        return scatterCanvas;
    }

    public MapCanvas newMap(int n) {
        return this.newMap(this.cvs, n);
    }

    public MapCanvas newMap(SVarSet sVarSet, int n) {
        this.updateMarker(sVarSet, n);
        SVar sVar = sVarSet.at(n);
        if (sVar == null || sVar.getContentsType() != 8) {
            return null;
        }
        String string = "Map (" + sVar.getName() + ")";
        FrameDevice frameDevice = this.newFrame(string, 141);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        MapCanvas mapCanvas = new MapCanvas(this.graphicsEngine, frameDevice.getFrame(), sVar, sVarSet.getMarker());
        frameDevice.add(mapCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(mapCanvas);
        }
        mapCanvas.setSize(new Dimension(400, 300));
        mapCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(mapCanvas.getWidth(), mapCanvas.getHeight()));
        frameDevice.pack();
        mapCanvas.repaint();
        this.addNewPlot(mapCanvas);
        return mapCanvas;
    }

    public BarCanvas newBarchart(int n) {
        return this.newBarchart(this.cvs, n, -1);
    }

    public BarCanvas newBarchart(int n, int n2) {
        return this.newBarchart(this.cvs, n, n2);
    }

    public BarCanvas newBarchart(SVarSet sVarSet, int n, int n2) {
        int n3;
        SVar sVar;
        this.updateMarker(sVarSet, n);
        SVar sVar2 = sVarSet.at(n);
        SVar sVar3 = sVar = n2 < 0 ? null : sVarSet.at(n2);
        if (sVar2 == null) {
            return null;
        }
        if (!sVar2.isCat()) {
            sVar2.categorize();
        }
        String string = sVar != null ? "w.Barchart (" + sVar2.getName() + "*" + sVar.getName() + ")" : "Barchart (" + sVar2.getName() + ")";
        FrameDevice frameDevice = this.newFrame(string, 135);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        BarCanvas barCanvas = new BarCanvas(this.graphicsEngine, frameDevice.getFrame(), sVar2, sVarSet.getMarker(), sVar);
        frameDevice.add(barCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(barCanvas);
        }
        if ((n3 = 100 + 40 * sVar2.getNumCats()) > 800) {
            n3 = 800;
        }
        barCanvas.setSize(new Dimension(n3, 200));
        barCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(barCanvas.getWidth(), barCanvas.getHeight()));
        frameDevice.pack();
        barCanvas.repaint();
        this.addNewPlot(barCanvas);
        return barCanvas;
    }

    public LineCanvas newLineplot(int[] nArray) {
        return this.newLineplot(this.cvs, -1, nArray);
    }

    public LineCanvas newLineplot(int n, int[] nArray) {
        return this.newLineplot(this.cvs, n, nArray);
    }

    public LineCanvas newLineplot(int n, int n2) {
        int[] nArray = new int[]{n2};
        return this.newLineplot(this.cvs, n, nArray);
    }

    public LineCanvas newLineplot(SVarSet sVarSet, int n, int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        this.updateMarker(sVarSet, nArray[0]);
        String string = "Lineplot";
        FrameDevice frameDevice = this.newFrame(string, 140);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        SVar[] sVarArray = new SVar[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sVarArray[i] = sVarSet.at(nArray[i]);
        }
        LineCanvas lineCanvas = new LineCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarSet.at(n), sVarArray, sVarSet.getMarker());
        frameDevice.add(lineCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(lineCanvas);
        }
        lineCanvas.setSize(new Dimension(400, 300));
        lineCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(lineCanvas.getWidth(), lineCanvas.getHeight()));
        frameDevice.pack();
        lineCanvas.repaint();
        return lineCanvas;
    }

    public HamCanvas newHammock(int[] nArray) {
        return this.newHammock(this.cvs, nArray);
    }

    public HamCanvas newHammock(SVarSet sVarSet, int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        this.updateMarker(sVarSet, nArray[0]);
        String string = "Hammock plot";
        FrameDevice frameDevice = this.newFrame(string, 139);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        SVar[] sVarArray = new SVar[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sVarArray[i] = sVarSet.at(nArray[i]);
        }
        HamCanvas hamCanvas = new HamCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarArray, sVarSet.getMarker());
        frameDevice.add(hamCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(hamCanvas);
        }
        hamCanvas.setSize(new Dimension(400, 300));
        hamCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(hamCanvas.getWidth(), hamCanvas.getHeight()));
        frameDevice.pack();
        hamCanvas.repaint();
        this.addNewPlot(hamCanvas);
        return hamCanvas;
    }

    public MosaicCanvas newMosaic(int[] nArray) {
        return this.newMosaic(this.cvs, nArray);
    }

    public MosaicCanvas newMosaic(SVarSet sVarSet, int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        this.updateMarker(sVarSet, nArray[0]);
        String string = "(";
        for (int i = 0; i < nArray.length - 1; ++i) {
            string = string + sVarSet.at(nArray[i]).getName() + ", ";
        }
        string = string + sVarSet.at(nArray[nArray.length - 1]).getName() + ")";
        FrameDevice frameDevice = this.newFrame("Mosaic plot " + string, 139);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        SVar[] sVarArray = new SVar[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sVarArray[i] = sVarSet.at(nArray[i]);
        }
        MosaicCanvas mosaicCanvas = new MosaicCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarArray, sVarSet.getMarker());
        frameDevice.add(mosaicCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(mosaicCanvas);
        }
        mosaicCanvas.setSize(new Dimension(400, 300));
        mosaicCanvas.setTitle("Mosaic plot " + string);
        frameDevice.setSize(new Dimension(mosaicCanvas.getWidth(), mosaicCanvas.getHeight()));
        frameDevice.pack();
        mosaicCanvas.repaint();
        this.addNewPlot(mosaicCanvas);
        return mosaicCanvas;
    }

    public ParallelAxesCanvas newPCP(int[] nArray) {
        return this.newPCP(this.cvs, nArray);
    }

    public ParallelAxesCanvas newPCP(SVarSet sVarSet, int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        this.updateMarker(sVarSet, nArray[0]);
        String string = "Parallel coord. plot (" + sVarSet.getName() + ")";
        FrameDevice frameDevice = this.newFrame(string, 139);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        SVar[] sVarArray = new SVar[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sVarArray[i] = sVarSet.at(nArray[i]);
        }
        ParallelAxesCanvas parallelAxesCanvas = new ParallelAxesCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarArray, sVarSet.getMarker(), 0);
        frameDevice.add(parallelAxesCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(parallelAxesCanvas);
        }
        parallelAxesCanvas.setSize(new Dimension(400, 300));
        parallelAxesCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(parallelAxesCanvas.getWidth(), parallelAxesCanvas.getHeight()));
        frameDevice.pack();
        parallelAxesCanvas.repaint();
        this.addNewPlot(parallelAxesCanvas);
        return parallelAxesCanvas;
    }

    public HistCanvas newHistogram(int n) {
        return this.newHistogram(this.cvs, n);
    }

    public HistCanvas newHistogram(SVarSet sVarSet, int n) {
        this.updateMarker(sVarSet, n);
        String string = "Histogram (" + sVarSet.at(n).getName() + ")";
        FrameDevice frameDevice = this.newFrame(string, 136);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        HistCanvas histCanvas = new HistCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarSet.at(n), sVarSet.getMarker());
        frameDevice.add(histCanvas.getComponent());
        histCanvas.updateObjects();
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(histCanvas);
        }
        histCanvas.setSize(new Dimension(400, 300));
        histCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(histCanvas.getWidth(), histCanvas.getHeight()));
        frameDevice.pack();
        histCanvas.repaint();
        this.addNewPlot(histCanvas);
        return histCanvas;
    }

    public ParallelAxesCanvas newBoxplot(int n) {
        return this.newBoxplot(this.cvs, new int[]{n}, -1);
    }

    public ParallelAxesCanvas newBoxplot(int n, int n2) {
        return this.newBoxplot(this.cvs, new int[]{n}, n2);
    }

    public ParallelAxesCanvas newBoxplot(int[] nArray) {
        return this.newBoxplot(this.cvs, nArray, -1);
    }

    public ParallelAxesCanvas newBoxplot(int[] nArray, int n) {
        return this.newBoxplot(this.cvs, nArray, n);
    }

    public ParallelAxesCanvas newBoxplot(SVarSet sVarSet, int[] nArray, int n) {
        int n2;
        SVar sVar = n < 0 ? null : sVarSet.at(n);
        this.updateMarker(sVarSet, nArray[0]);
        String string = "Boxplot (" + sVarSet.at(nArray[0]).getName() + ")" + (sVar != null ? " by " + sVar.getName() : "");
        FrameDevice frameDevice = this.newFrame(string, 138);
        frameDevice.initPlacement();
        frameDevice.setVisible(true);
        frameDevice.addWindowListener(Common.getDefaultWindowListener());
        SVar[] sVarArray = new SVar[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sVarArray[i] = sVarSet.at(nArray[i]);
        }
        ParallelAxesCanvas parallelAxesCanvas = sVar == null ? new ParallelAxesCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarArray, sVarSet.getMarker(), 1) : new ParallelAxesCanvas(this.graphicsEngine, frameDevice.getFrame(), sVarArray[0], sVar, sVarSet.getMarker(), 1);
        frameDevice.add(parallelAxesCanvas.getComponent());
        if (sVarSet.getMarker() != null) {
            sVarSet.getMarker().addDepend(parallelAxesCanvas);
        }
        int n3 = n2 = sVar == null ? 40 + 40 * nArray.length : 40 + 40 * sVar.getNumCats();
        if (n2 > 800) {
            n2 = 800;
        }
        parallelAxesCanvas.setSize(new Dimension(n2, 200));
        parallelAxesCanvas.setTitle(string);
        frameDevice.setSize(new Dimension(parallelAxesCanvas.getWidth(), parallelAxesCanvas.getHeight()));
        frameDevice.pack();
        parallelAxesCanvas.repaint();
        this.addNewPlot(parallelAxesCanvas);
        return parallelAxesCanvas;
    }

    public double[] getDoubleContent(int n) {
        SVar sVar = this.cvs.at(n);
        if (sVar == null) {
            return null;
        }
        double[] dArray = new double[sVar.size()];
        for (int i = 0; i < sVar.size(); ++i) {
            dArray[i] = sVar.atD(i);
        }
        return dArray;
    }

    public String[] getStringContent(int n) {
        SVar sVar = this.cvs.at(n);
        if (sVar == null) {
            return null;
        }
        String[] stringArray = new String[sVar.size()];
        for (int i = 0; i < sVar.size(); ++i) {
            stringArray[i] = sVar.atS(i);
        }
        return stringArray;
    }

    public double[] getDoubleContent(SVar sVar) {
        if (sVar == null) {
            return null;
        }
        double[] dArray = new double[sVar.size()];
        for (int i = 0; i < sVar.size(); ++i) {
            dArray[i] = sVar.atD(i);
        }
        return dArray;
    }

    public String[] getStringContent(SVar sVar) {
        if (sVar == null) {
            return null;
        }
        String[] stringArray = new String[sVar.size()];
        for (int i = 0; i < sVar.size(); ++i) {
            stringArray[i] = sVar.atS(i);
        }
        return stringArray;
    }

    public int varIsNum(int n) {
        SVar sVar = this.cvs.at(n);
        if (sVar == null) {
            return -1;
        }
        return sVar.isNum() ? 1 : 0;
    }

    public int varIsNum(SVar sVar) {
        if (sVar == null) {
            return -1;
        }
        return sVar.isNum() ? 1 : 0;
    }

    public void setSecMark(int[] nArray) {
        this.setSecMark(nArray, true);
    }

    public void setSecMark(int[] nArray, boolean bl) {
        if (this.cvs == null) {
            return;
        }
        int n = 0;
        SMarker sMarker = this.cvs.getMarker();
        for (int i = 0; n < nArray.length && i < sMarker.size(); ++i) {
            sMarker.setSec(i, nArray[n]);
            if (!bl || ++n < nArray.length) continue;
            n = 0;
        }
        sMarker.NotifyAll(new NotifyMsg(this, 4098));
    }

    public void updateMarker() {
        if (this.cvs != null) {
            this.cvs.getMarker().NotifyAll(new NotifyMsg(this, 4096));
        }
    }

    public void updateVars() {
        if (this.cvs != null) {
            this.cvs.getMarker().NotifyAll(new NotifyMsg(this, 12288));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Common.breakDispatcher.NotifyAll(new NotifyMsg(this, 0x800001, actionEvent.getActionCommand()));
    }

    public void setDebugLevel(int n) {
        if (Global.DEBUG > 0) {
            System.out.println("Setting DEBUG level to " + n);
        }
        if ((Global.DEBUG = n) > 0) {
            System.out.println("DEBUG level set to " + Global.DEBUG);
        }
    }

    private synchronized NotifyMsg waitForNotification() {
        while (!this.notificationArrived) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notificationArrived = false;
        NotifyMsg notifyMsg = this.lastNotificationMessage;
        this.lastNotificationMessage = null;
        return notifyMsg;
    }

    private synchronized void triggerNotification(NotifyMsg notifyMsg) {
        this.notificationArrived = true;
        this.lastNotificationMessage = notifyMsg;
        this.notifyAll();
    }

    public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
        this.triggerNotification(notifyMsg);
    }

    public NotifyMsg eventWait() {
        NotifyMsg notifyMsg = this.waitForNotification();
        return notifyMsg == null || notifyMsg.getMessageID() == 0x700000 ? null : notifyMsg;
    }

    public String d2s(double d) {
        return Double.toString(d);
    }

    public void setExtQueryString(int n, String string) {
        if (string == null) {
            this.useExtQueryString(n, false);
            return;
        }
        if (this.plots == null || n < -1 || n > this.plots.length) {
            return;
        }
        if (n == -1) {
            for (int i = 0; i < this.plots.length; ++i) {
                this.plots[i].setExtQueryString(string);
            }
        } else {
            this.plots[n - 1].setExtQueryString(string);
        }
    }

    public void useExtQueryString(int n, boolean bl) {
        if (this.plots == null || n < -1 || n > this.plots.length) {
            return;
        }
        if (n == -1) {
            for (int i = 0; i < this.plots.length; ++i) {
                this.plots[i].useExtQuery(bl);
            }
        } else {
            this.plots[n - 1].useExtQuery(bl);
        }
    }
}

