% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_ptm_enzymes_from_list}
\alias{get_ptm_enzymes_from_list}
\title{Get PTM Enzymes from list}
\usage{
get_ptm_enzymes_from_list(items)
}
\arguments{
\item{items}{A list of kinases.}
}
\value{
A Dataframe representing the enzymes
}
\description{
Retrieve PTM enxymes from the given list of kinases.
The kinase object should have three fields - "substrate_ac","site_residue","site_position". All with the type String
}
\examples{
\dontrun{
kinases = list(
  list(
      substrate_ac="Q15796",
      site_residue="K",
      site_position="19"
  ),
  list(
      substrate_ac="Q15796",
      site_residue="T",
      site_position="8"
 ),
 list(
      substrate_ac="P04637",
      site_residue="K",
      site_position="120"
 )
)
enzymes = get_ptm_enzymes_from_list(kinases)
}
}
