% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_analysis.R
\name{distractor_analysis}
\alias{distractor_analysis}
\title{Distractor Analysis Function}
\usage{
distractor_analysis(resp, key = NULL, ip = NULL, criterion = NULL)
}
\arguments{
\item{resp}{It can be either a \code{\link{Response_set-class}} object with
valid raw responses; or, a \code{matrix} or \code{data.frame} containing
the raw item responses.}

\item{key}{The answer key for the responses. Keys can also be provided via
\code{ip} argument.}

\item{ip}{An \code{\link{Itempool-class}} object that contains the keys of
the items. The program will look check whether a \code{ip$misc$key} is
specified for all items. Valid keys should be provided via \code{ip} if
\code{key} argument is \code{NULL}.}

\item{criterion}{Provide a continuous criterion variable such as a total
raw score, or theta score that will be used in the calculation of
correlation calculations. If this value is \code{NULL}, the total score
will be used.}
}
\value{
A data.frame with following columns
  \describe{
    \item{'item_id'}{Item identifier}
    \item{'key'}{Answer key}
    \item{'option'}{The selected option}
    \item{'n'}{Number of subjects/examinees answered this item}
    \item{'prop'}{Observed proportions of the choice.}
    \item{'bis'}{Biserial correlation between the examinees selected
          the choice and the total scores.}
    \item{'pbis'}{Point-biserial correlation between the
          examinees selected the choice and the total scores.}
    \item{'bis_adj'}{Biserial correlation between item and total score
      without this item. Sum scores will be used in the calculation of
      'bis_adj' even 'criterion' is provided. }
    \item{'pbis_adj'}{Point-biserial correlation between item and total score
      without this item. Sum scores will be used in the calculation of
      'bis_adj' even 'criterion' is provided.}
  }
}
\description{
Distractor Analysis Function
}
\examples{
n_item <- 10 # sample(8:12, 1)
n_theta <- 50 # sample(100:200, 1)
raw_resp <- matrix(sample(LETTERS[1:4], n_item * n_theta, replace = TRUE),
                   nrow = n_theta, ncol = n_item,
                   dimnames = list(paste0("Examinee-", 1:n_theta),
                                   paste0("Item-", 1:n_item)))
# Add some missing responses
raw_resp[sample(1:length(raw_resp), round(length(raw_resp)*.1))] <- NA
# Prepare answer key
key <- sample(LETTERS[1:4], n_item, replace = TRUE)

# Run distractor analysis:
da <- distractor_analysis(resp = raw_resp, key = key)


}
\author{
Emre Gonulates
}
